/*******************************************************************
This software module was originally developed by

Yasuhiro Toguri (Sony Corporation) 

in the course of development of the MPEG-2 NBC/MPEG-4 System/MPEG-4
Video/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3. This
software module is an implementation of a part of one or more MPEG-2
NBC/MPEG-4 System/MPEG-4 Video/MPEG-4 Audio tools as specified by the
MPEG-2 NBC/MPEG-4 System/MPEG-4 Video/MPEG-4 Audio standard. ISO/IEC
gives users of the MPEG-2 NBC/MPEG-4 System/MPEG-4 Video/MPEG-4 Audio
standards free license to this software module or modifications
thereof for use in hardware or software products claiming conformance
to the MPEG-2 NBC/MPEG-4 System/MPEG-4 Video/MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 System/MPEG-4 Video/MPEG-4 Audio conforming products.The
original developer retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to inhibit
third party from using the code for non MPEG-2 NBC/MPEG-4
System/MPEG-4 Video/MPEG-4 Audio conforming products. This copyright
notice must be included in all copies or derivative works.

Copyright (C) 1996.
*******************************************************************/

#include	"sony_local.h"
#include	<stdlib.h>
#include	<math.h>


void	son_gc_detect_reset(
	double	*bandSigChForGCAnalysis[],
	int	block_size_samples,
	int	window_sequence,
	int	ch,
	GAINC	*g_info_curCh[]
	)
{
	int	i;
    int wd;

	for (i = 0; i < NBANDS; i++) {
		switch(window_sequence) {
		case EIGHT_SHORT_SEQUENCE:
			for(wd=0;wd< SHORT_WIN_IN_LONG;wd++)
				g_info_curCh[i][wd].natks = 0;
			break;
		case ONLY_LONG_SEQUENCE:
			g_info_curCh[i][0].natks = 0;
			break;
		case LONG_START_SEQUENCE:
			g_info_curCh[i][0].natks = 0;
			break;
		case LONG_STOP_SEQUENCE:
			g_info_curCh[i][0].natks = 0;
			break;
		default:
			fprintf(stderr, "detect_reset:invalid window_sequence: %d\n", window_sequence);
			exit(-1);
			break;
		}
	}
}

