/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Akio Jin (NTT),                                                         */
/*   Takeshi Norimatsu,                                                      */
/*   Mineo Tsushima,                                                         */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/* and edited by                                                             */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Naoki Iwakami (NTT) on 1997-07-17                                       */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1997.                                                        */
/*****************************************************************************/

#include "tf_main.h"
#include "bitstream.h"
#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "ntt_scale_encode.h"
#include "mat_def_ntt.h"

void ntt_scale_vq_coder(double      *spectral_line_vector[MAX_TIME_CHANNELS],
			double      lpc_spectrum[],
			ntt_INDEX   *index,
			ntt_INDEX   *index_scl,
			ntt_PARAM   *param_ntt,
			double      *reconstructed_spectrum[MAX_TIME_CHANNELS],
			int         iscl)
{
  /*--- Variables ---*/
  int ismp, i_ch;
  long top;
  ntt_PARAM param_ntt2;
  double spectrum2[ntt_T_FR_MAX],
         mat_spectrum2[ntt_T_FR_MAX];
  double lpc_spectrum2[ntt_T_FR_MAX];
  double bark_env[ntt_T_FR_MAX];
  double pitch_sequence[ntt_T_FR_MAX];
  double gain[ntt_T_SHRT_MAX];
  double perceptual_weight[ntt_T_FR_MAX];
  double spectrum_gain;
  double lpc_spectrum_out[ntt_T_FR_MAX];

  /*--- set parameters ---*/
  switch(index->w_type){
    /* long */
  case ONLY_LONG_WINDOW: case LONG_SHORT_WINDOW: case SHORT_LONG_WINDOW:
  case LONG_MEDIUM_WINDOW: case MEDIUM_LONG_WINDOW:
    spectrum_gain = 1./sqrt((double)ntt_N_FR*2.); /* spec. norm. gain */
    break;
    /* medium */
  case ONLY_MEDIUM_WINDOW: case MEDIUM_SHORT_WINDOW:
  case SHORT_MEDIUM_WINDOW:
    spectrum_gain = 1./sqrt((double)ntt_N_FR_M*2.); /* spec. norm. gain */
    break;
    /* short */
  case ONLY_SHORT_WINDOW:
    spectrum_gain = 1./sqrt((double)ntt_N_FR_S*2.); /* spec. norm. gain */
    break;
  default:
    fprintf(stderr, "ntt_vq_coder(): Error. %d: No such window type.\n",index->w_type);
    exit(1);
    break;
  }



  /*--- Hand data to scalable coder ---*/
  param_ntt2.speech_sw = param_ntt->speech_sw;
  param_ntt2.fine_sw   = param_ntt->fine_sw;

  /*--- Scalable coder ---*/
  index_scl->w_type = index->w_type;
  index_scl->pf = index->pf;
  /* make input coefficients */
  for (i_ch =0 ; i_ch < ntt_N_SUP ; i_ch++){
       top = i_ch * ntt_N_FR ;
       for (ismp=0; ismp<ntt_N_FR; ismp++){
	    spectrum2[ismp+top] =  spectrum_gain * 
		      (spectral_line_vector[i_ch][ismp] - reconstructed_spectrum[i_ch][ismp]);
	    mat_spectrum2[ismp+top] = spectrum2[ismp+top] ;
       }
  }
 /* Base,Enh-1 : fix   Enh-2... : flex */ 
  if(iscl==0){
      for(i_ch = 0; i_ch<ntt_N_SUP; i_ch++){
	mat_shift[iscl][i_ch] =0;
      }
  }
  else if(iscl>=1){
       mat_scale_lay_shift2(mat_spectrum2,&(*spectral_line_vector[0]),
			   iscl,index_scl);
#if 1 /*TM980301 */
       mat_scale_set_shift_para2(iscl);
#endif
   }
  /* spectrum normalization tool */
  ntt_scale_tf_proc_spectrum(spectrum2, index_scl,
                               lpc_spectrum2, bark_env,
                               pitch_sequence, gain, iscl,
                               lpc_spectrum, lpc_spectrum_out);

  /* calculate perceptual weight */
  ntt_scale_tf_perceptual_model(lpc_spectrum2, bark_env, gain,
                                index_scl->w_type,
                                spectrum2, pitch_sequence,
                                perceptual_weight);
                  
  /* VQ tool */
  mat_scale_tf_quantize_spectrum(spectrum2, lpc_spectrum2, bark_env,
                                   pitch_sequence,
                                   gain, perceptual_weight, index_scl,
                                   iscl);
  /* local decoding */
  ntt_scale_vq_decoder(index_scl, reconstructed_spectrum, iscl);
}
