/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 18-apr-97   NI   removed the interleaved VQ part */

#include "ntt_conf.h"
void ntt_set_interleave(enum ntt_INTERLEAVE_SET_MODE set_mode)
{
  int j, i;
  short serial;
  int i_div, acci, bits[ntt_max(ntt_N_DIV_P_MAX,ntt_N_DIV_MAX)*2];
  int length[ntt_max(ntt_N_DIV_P_MAX,ntt_N_DIV_MAX)*2];
  int flag_long, flag_medium, flag_short, flag_pitch;


  flag_long = flag_medium = flag_short = flag_pitch = 0;
  switch(set_mode){
  case ntt_INTR_ALL:
    flag_long = flag_medium = flag_short = flag_pitch = 1;
    break;
  case ntt_INTR_LONG:
    flag_long = 1;
    break;
  case ntt_INTR_SHORT:
    flag_short = 1;
    break;
  case ntt_INTR_MEDIUM:
    flag_medium = 1;
    break;
  case ntt_INTR_PITCH:
    flag_pitch = 1;
    break;
  default:
    fprintf(stderr, "set_interleave(): Set mode %d is unknow.\n",
	    set_mode);
    exit(1);
  }


  if (flag_pitch){
    /* for pitch VQ */
    ntt_BIT_REVp[0] = 0;
    ntt_vec_lenp(bits, length);
    serial =0;
    for(i = 0 ; i < ntt_N_DIV_P ; i++) {
      for(j=0; j<length[0]-1; j++){
	if((ntt_N_SUP==1) ||((ntt_N_DIV_P%ntt_N_SUP)!=0)) acci = i+ntt_N_DIV_P*j;
	else                 acci = ((i+j)%ntt_N_DIV_P)+ntt_N_DIV_P*j;
	ntt_BIT_REVp[serial++] = acci/ntt_N_SUP + (acci%ntt_N_SUP)*ntt_N_FR_P;
      } 
      for(j=length[0]-1; j<length[i]; j++){
	acci = i+ntt_N_DIV_P*j;
	ntt_BIT_REVp[serial++] = acci/ntt_N_SUP + (acci%ntt_N_SUP)*ntt_N_FR_P;
      } 
    }
    acci=0;
    for (i_div=0; i_div<ntt_N_DIV_P; i_div++){
      ntt_SMP_ACCp[i_div] = acci; 
      acci += length[i_div]; 
    }
  }
}
