/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Akio Jin (NTT),                                                         */
/*   Takeshi Norimatsu,                                                      */
/*   Mineo Tsushima,                                                         */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/* and edited by                                                             */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1997.                                                        */
/*****************************************************************************/


#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"


void ntt_scale_init(int iscl, int cb_lyr)
{
  /*--- Variables ---*/
  int  flag, flag2, flag3, ii;
  int  LSP_TBIT;
  int  GAIN_TBIT, GAIN_TBIT_M, GAIN_TBIT_S;
  int  FW_TBIT, FW_TBIT_S, FW_TBIT_M;
  /*  int  ntt_CB_LEN_READ, ntt_CB_LEN_READ_M, ntt_CB_LEN_READ_S; */
  int  IBPS_tmp;
  int i_ch, iscl0;

  ntt_IBPS_SCL[iscl] /= ntt_N_SUP;

  /*--- Set bitrate mode ---*/
  ntt_BPS_SCL[iscl] = (double)ntt_IBPS_SCL[iscl]*1000.;
  if (ntt_IBPS_SCL[iscl] >= 8){
    IBPS_tmp = 8;
  }
  else{
    fprintf(stderr, "ntt_scale_init(): %d: invalid bitrate.\n",
            ntt_IBPS_SCL[iscl]);
    exit(1);
  }

  /*--- Set mode table ---*/
#if 0
  flag=0;
  /* 48 kHz sampling */
  if ( ntt_ISAMPF==48 && IBPS_tmp==8 ){
    ntt_scale_cp_mdtbl( ntt_mode_48_16_scl, iscl );
    flag=1;
  }
#endif

  flag=0;
#if 0
  /* 48 kHz sampling */
  if ( ntt_ISAMPF==48 && IBPS_tmp==8 && iscl==0){
    ntt_scale_cp_mdtbl( ntt_mode_48_16_scl, iscl );
    flag=1;
  }
  /* 48 kHz sampling */
  if ( ntt_ISAMPF==48 && IBPS_tmp==8 && iscl >=1){
    ntt_scale_cp_mdtbl( ntt_mode_48_24_scl, iscl );
    flag=1;
  }

#endif
  /* 24 kHz sampling */
  if ( ntt_ISAMPF<=48 && IBPS_tmp==8 && iscl==0){
    ntt_scale_cp_mdtbl( ntt_mode_24_16_scl, iscl );
    flag=1;
  }
  /* 24 kHz sampling */
  if ( ntt_ISAMPF<=48 && IBPS_tmp==8 && iscl >=1){
    ntt_scale_cp_mdtbl( ntt_mode_24_24_scl, iscl );
    flag=1;
  }

  if ( flag==0 ){
    fprintf( stderr, "ntt_ISAMPF: %d, ntt_IBPS2: %d --- Not supported\n",
             ntt_ISAMPF, IBPS_tmp );
    exit(1);
  }
    
  /*--- Set other variables ---*/
  /*----------------------------------------------------------------------*/
  /* PROGRAM MODE                                                         */
  /*----------------------------------------------------------------------*/
  /* band limit */
#if 1 /* TM980501 */
  ntt_BAND_UPPER_SCL[iscl] = b_lim_tbl[ntt_BAND_UPPER_ID_SCL[iscl]];
  ntt_BAND_LOWER_SCL[iscl] = b_lim_tbl[ntt_BAND_LOWER_ID_SCL[iscl]];
#endif
  if(ntt_ISAMPF == 24){
    for(iscl0=0; iscl0<LX; iscl0++){
      for(i_ch=0; i_ch<ntt_N_SUP; i_ch++){
        ntt_AC_TOP[iscl0][i_ch][0] = 2./3.;
        ntt_AC_BTM[iscl0][i_ch][0] = 0.0;
        ntt_AC_TOP[iscl0][i_ch][1] = 2./3.+1./12.;
        ntt_AC_BTM[iscl0][i_ch][1] = 1./12.;
        ntt_AC_TOP[iscl0][i_ch][2] = 2./3.+1./6.;
        ntt_AC_BTM[iscl0][i_ch][2] = 1./6.;
        ntt_AC_TOP[iscl0][i_ch][3] = 1.0;
        ntt_AC_BTM[iscl0][i_ch][3] = 1./3.;
      }
    }
  }
  else{
    { double qsample, bias;
     qsample = min(1.0, (double)ntt_IBPS_SCL[iscl]/(double)ntt_ISAMPF*1.2);
     bias = (1. - qsample)/3.0;
     for(iscl0=0; iscl0<LX; iscl0++){
      for(i_ch=0; i_ch<ntt_N_SUP; i_ch++){
        ntt_AC_TOP[iscl0][i_ch][0] = qsample;
        ntt_AC_BTM[iscl0][i_ch][0] = 0.0;
        ntt_AC_TOP[iscl0][i_ch][1] = qsample+bias;
        ntt_AC_BTM[iscl0][i_ch][1] = bias;
        ntt_AC_TOP[iscl0][i_ch][2] = qsample + bias*2;
        ntt_AC_BTM[iscl0][i_ch][2] = bias*2;
        ntt_AC_TOP[iscl0][i_ch][3] = 1.0;
        ntt_AC_BTM[iscl0][i_ch][3] = bias*3;
      }
     }
    }
  
  }

  /*----------------------------------------------------------------------*/
  /* GAIN QUANTIZATION                                                    */
  /*----------------------------------------------------------------------*/
  ntt_NUM_STEP_SCL[iscl] = 1<<ntt_GAIN_BITS_SCL[iscl];
  ntt_STEP_SCL[iscl]    = ntt_AMP_MAX_SCL[iscl] / (ntt_NUM_STEP_SCL[iscl] - 1);
  ntt_SUB_NUM_STEP_SCL[iscl] = 1<<ntt_SUB_GAIN_BITS_SCL[iscl];
  ntt_SUB_STEP_SCL[iscl]     = 
    ntt_SUB_AMP_MAX_SCL[iscl] / (ntt_SUB_NUM_STEP_SCL[iscl] - 1);
    
  /* number of bits for gain quantization tool */
  GAIN_TBIT = ntt_GAIN_BITS_SCL[iscl] * ntt_N_SUP;
  GAIN_TBIT_M =
    (ntt_GAIN_BITS_SCL[iscl] + ntt_SUB_GAIN_BITS_SCL[iscl] * ntt_N_MID) 
    * ntt_N_SUP;
  GAIN_TBIT_S =
    (ntt_GAIN_BITS_SCL[iscl] + ntt_SUB_GAIN_BITS_SCL[iscl] * ntt_N_SHRT)
    * ntt_N_SUP;

  /*----------------------------------------------------------------------*/
  /* LSP QUANTIZATION                                                     */
  /*----------------------------------------------------------------------*/
  /* parameter settings */
  ntt_N_MODE_SCL[iscl]    = (1<<ntt_LSP_BIT0_SCL[iscl]);
  ntt_cnst_chk(ntt_N_MODE_SCL[iscl], ntt_N_MODE_MAX,
               "Number of LSP quant. modes" );
  ntt_NC0_SCL[iscl]       = (1<<ntt_LSP_BIT1_SCL[iscl]);
  ntt_cnst_chk( ntt_NC0_SCL[iscl], ntt_NC0_MAX, "ntt_NC0_SCL[iscl]" );
  ntt_NC1_SCL[iscl]       = (1<<ntt_LSP_BIT2_SCL[iscl]);
  ntt_cnst_chk( ntt_NC1_SCL[iscl], ntt_NC1_MAX, "ntt_NC1_SCL[iscl]" );

  /* codebook settings */
  ntt_lsp_csize_scl[iscl][0] = ntt_NC0_SCL[iscl];
  ntt_lsp_csize_scl[iscl][1] = ntt_NC1_SCL[iscl];
  ntt_lsp_cdim_scl[iscl][0] = ntt_lsp_cdim_scl[iscl][1] = ntt_N_PR_SCL[iscl];
  /* codebook memory allocation and reading */
  if (iscl < cb_lyr){
    lsp_code_scl[iscl] = 
      (double *)malloc((ntt_NC0_SCL[iscl]+ntt_NC1_SCL[iscl])*ntt_N_PR_MAX
                       *sizeof(double));
    lsp_fgcode_scl[iscl] = 
      (double *)malloc(ntt_N_MODE_SCL[iscl]*ntt_MA_NP*ntt_N_PR_MAX
                       *sizeof(double));
    ntt_get_code(ntt_LSPCODEBOOK_SCL[iscl], ntt_LSP_NSTAGE,
                 ntt_lsp_csize_scl[iscl],
                 ntt_lsp_cdim_scl[iscl],
                 (double (*)[ntt_N_PR_MAX])lsp_code_scl[iscl],
                 (double (*)[ntt_MA_NP][ntt_N_PR_MAX])lsp_fgcode_scl[iscl]);
  }

  /* number of bits for LSP quantization tool */
  LSP_TBIT =
    (ntt_LSP_BIT0_SCL[iscl] + ntt_LSP_BIT1_SCL[iscl] 
     + ntt_LSP_BIT2_SCL[iscl] * ntt_LSP_SPLIT_SCL[iscl]) * ntt_N_SUP;

  /*----------------------------------------------------------------------*/
  /* FORWARD ENVELOPE QUANTIZATION                                        */
  /*----------------------------------------------------------------------*/
    
  /*--- Load bark-scale subband tables ---*/
  flag = flag2 = flag3 = 0;
#if 0
  /*--------- sampling rate == 48 kHz ---------*/

  if(iscl == 0){
    if ((ntt_ISAMPF == 48) && (ntt_N_FR == 2048)){
      if (IBPS_tmp == 8){
        ntt_N_CRB_SCL[iscl] = ntt_N_CRB_48_2048_2nd;
        for(ii=0;ii<ntt_N_CRB_SCL[iscl];ii++){
          ntt_crb_tbl_scl[iscl][ii] = ntt_crb_tbl_48_2048_2nd[ii];
        }
      }
      flag = 1;
    }
  }

  if(iscl >= 1){
    if ((ntt_ISAMPF == 48) && (ntt_N_FR == 2048)){
      if (IBPS_tmp == 8){
        ntt_N_CRB_SCL[iscl] = ntt_N_CRB_48_2048_3rd;
        for(ii=0;ii<ntt_N_CRB_48_2048_3rd;ii++){

          ntt_crb_tbl_scl[iscl][ii] =
            (int)(((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR )
                  + ntt_crb_tbl_48_2048_3rd[ii]);
        }
      }
      flag = 1;
    }
  }

  if(iscl == 0){
    if ((ntt_ISAMPF == 48) && (ntt_N_FR_S == 128)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_48_128_2nd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii] = ntt_crb_tbl_s_48_128_2nd[ii];
      }
      flag2 = 1;
    }
  }

  if(iscl >= 1){
    if ((ntt_ISAMPF == 48) && (ntt_N_FR_S == 128)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_48_128_3rd;

      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii]
          = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_SHRT + ntt_crb_tbl_s_48_128_3rd[ii]);
      }
      flag2 = 1;
    }
  }


  if(iscl == 0){
    if ((ntt_ISAMPF == 48) && (ntt_N_FR_M == 512)){
      switch(IBPS_tmp){
      case 8:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_48_512_2nd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii] = ntt_crb_tbl_48_512_2nd[ii];
        }
        break;
      default:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_48_512;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii] = ntt_crb_tbl_48_512_2nd[ii];
        }
      }
      flag3 = 1;
    }
  }
  if(iscl >= 1){
    if ((ntt_ISAMPF == 48) && (ntt_N_FR_M == 512)){
      switch(IBPS_tmp){
      case 8:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_48_512_3rd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii]
            = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID + ntt_crb_tbl_48_512_3rd[ii]);

        }
        break;
      default:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_48_512;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii]
            += (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID + ntt_crb_tbl_48_512_3rd[ii]);
        }
      }
      flag3 = 1;
    }
  }
#endif

  /*---------- sampling rate == 24 kHz ----------*/
  if(iscl == 0){
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR == 1024)){
      if (IBPS_tmp == 8){
        ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_1024_2nd;
        for(ii=0;ii<ntt_N_CRB_SCL[iscl];ii++){
          ntt_crb_tbl_scl[iscl][ii] = ntt_crb_tbl_24_1024_2nd[ii];
        }
      }
      flag = 1;
    }
  }
  if(iscl == 0){
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR == 960)){
      if (IBPS_tmp == 8){
        ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_960_2nd;
        for(ii=0;ii<ntt_N_CRB_SCL[iscl];ii++){
          ntt_crb_tbl_scl[iscl][ii] = ntt_crb_tbl_24_960_2nd[ii];
        }
      }
      flag = 1;
    }
  }

  if(iscl >= 1){
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR == 1024)){
      if (IBPS_tmp == 8){
        ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_1024_3rd;
        for(ii=0;ii<ntt_N_CRB_24_1024_3rd;ii++){
          ntt_crb_tbl_scl[iscl][ii] =
            (int)(((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR )
                  + ntt_crb_tbl_24_1024_3rd[ii]);
        }
      }
      flag = 1;
    }
  }

  if(iscl >= 1){
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR == 960)){
      if (IBPS_tmp == 8){
        ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_960_3rd;
        for(ii=0;ii<ntt_N_CRB_24_1024_3rd;ii++){
          ntt_crb_tbl_scl[iscl][ii] =
            (int)(((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR )
                  + ntt_crb_tbl_24_960_3rd[ii]);
        }
      }
      flag = 1;
    }
  }

  if(iscl == 0){
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_S == 64)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_2nd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii] = ntt_crb_tbl_s_24_64_2nd[ii];
      }
      flag2 = 1;
    }
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_S == 60)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_2nd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii] = ntt_crb_tbl_s_24_64_2nd[ii];
      }
      flag2 = 1;
    }
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR_S == 120)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_2nd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii] = ntt_crb_tbl_s_24_64_2nd[ii];
      }
      flag2 = 1;
    }
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR_S == 128)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_2nd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii] = ntt_crb_tbl_s_24_64_2nd[ii];
      }
      flag2 = 1;
    }
  }

  if(iscl >= 1){
#if 0
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_S == 64)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii]
          = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])
                  *ntt_N_FR/ntt_N_SHRT + ntt_crb_tbl_s_24_64_3rd[ii]);
      }
      flag2 = 1;
    }
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_S == 60)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii]
          = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])
                  *ntt_N_FR/ntt_N_SHRT + ntt_crb_tbl_s_24_64_3rd[ii]);
      }
      flag2 = 1;
    }
#endif
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR_S == 120)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii]
          = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])
                  *ntt_N_FR/ntt_N_SHRT + ntt_crb_tbl_s_24_64_3rd[ii]);
      }
      flag2 = 1;
    }
    if ((ntt_ISAMPF <= 48) && (ntt_N_FR_S == 128)){
      ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
      for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
        ntt_crb_tbl_s_scl[iscl][ii]
          = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])
                  *ntt_N_FR/ntt_N_SHRT + ntt_crb_tbl_s_24_64_3rd[ii]);
      }
      flag2 = 1;
    }
  }

#if 0
  if(iscl == 0){
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_M == 256)){
      switch(IBPS_tmp){
      case 8:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_2nd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii] = ntt_crb_tbl_24_256_2nd[ii];
        }
        break;
      default:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_2nd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii] = ntt_crb_tbl_24_256_2nd[ii];
        }
      }
      flag3 = 1;
    }
  }
  if(iscl == 0){
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_M == 240)){
      switch(IBPS_tmp){
      case 8:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_2nd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii] = ntt_crb_tbl_24_256_2nd[ii];
        }
        break;
      default:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_2nd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii] = ntt_crb_tbl_24_256_2nd[ii];
        }
      }
      flag3 = 1;
    }
  }

  if(iscl >= 1){
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_M == 256)){
      switch(IBPS_tmp){
      case 8:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_3rd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii]
            = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID + ntt_crb_tbl_24_256_3rd[ii]);

        }
        break;
      default:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_3rd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii]
            += (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID + ntt_crb_tbl_24_256_3rd[ii]);
        }
      }
      flag3 = 1;
    }
  }

  if(iscl >= 1){
    if ((ntt_ISAMPF == 24) && (ntt_N_FR_M == 240)){
      switch(IBPS_tmp){
      case 8:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_3rd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii]
            = (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID + ntt_crb_tbl_24_256_3rd[ii]);

        }
        break;
      default:
        ntt_N_CRB_M_SCL[iscl] = ntt_N_CRB_24_256_3rd;
        for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
          ntt_crb_tbl_m_scl[iscl][ii]
            += (int)((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID + ntt_crb_tbl_24_256_3rd[ii]);
        }
      }
      flag3 = 1;
    }
  }
#endif

  if (!flag){
    fprintf(stderr,
            "ntt_ISAMPF: %d, ntt_N_FR: %d --- No subband table for this mode. 4\n", 
            ntt_ISAMPF, ntt_N_FR);
    exit(1);
  }
  if (!flag2){
    fprintf(stderr,
            "ntt_ISAMPF: %d, ntt_N_FR_S: %d --- No subband table for this mode. 5\n", 
            ntt_ISAMPF, ntt_N_FR_S);
    exit(1);
  }
    
  /*--- Set variables for envelope coding ---*/
  /* Envelope codebook size */
  ntt_FW_CB_SIZE_SCL[iscl]  = (1<<ntt_FW_N_BIT_SCL[iscl]);
  /* Envelope codebook length */
  ntt_FW_CB_LEN_SCL[iscl]   = (ntt_N_CRB_SCL[iscl]/ntt_FW_N_DIV_SCL[iscl]);
  ntt_cnst_chk( ntt_FW_CB_SIZE_SCL[iscl], ntt_FW_CB_SIZE_MAX,
                "ntt_FW_CB_SIZE_SCL[iscl]" );
  ntt_cnst_chk( ntt_FW_CB_LEN_SCL[iscl], ntt_FW_CB_LEN_MAX,
                "ntt_FW_CB_LEN_SCL[iscl]" );

  /* Envelope codebook size */
  ntt_FW_CB_SIZE_S_SCL[iscl]= (1<<ntt_FW_N_BIT_S_SCL[iscl]);
  /* Env. codebook length */
  ntt_FW_CB_LEN_S_SCL[iscl] = (ntt_N_CRB_S_SCL[iscl]/ntt_FW_N_DIV_S_SCL[iscl]);
  ntt_cnst_chk( ntt_FW_CB_SIZE_S_SCL[iscl], ntt_FW_CB_SIZE_S_MAX,
                "ntt_FW_CB_SIZE_S_SCL[iscl]" );
  ntt_cnst_chk( ntt_FW_CB_LEN_S_SCL[iscl], ntt_FW_CB_LEN_S_MAX,
                "ntt_FW_CB_LEN_S_SCL[iscl]" );
    
  /* Envelope codebook size */
  ntt_FW_CB_SIZE_M_SCL[iscl]= (1<<ntt_FW_N_BIT_M_SCL[iscl]);
  /* Env. codebook length */
  ntt_FW_CB_LEN_M_SCL[iscl] = (ntt_N_CRB_M_SCL[iscl]/ntt_FW_N_DIV_M_SCL[iscl]);
  ntt_cnst_chk( ntt_FW_CB_SIZE_M_SCL[iscl], ntt_FW_CB_SIZE_M_MAX,
                "ntt_FW_CB_SIZE_M2" );
  ntt_cnst_chk( ntt_FW_CB_LEN_M_SCL[iscl], ntt_FW_CB_LEN_M_MAX,
                "ntt_FW_CB_LEN_M2" );

  if (ntt_FW_N_BIT_SCL[iscl] > 0)
    FW_TBIT = (ntt_FW_N_BIT_SCL[iscl]*ntt_FW_N_DIV_SCL[iscl]+ntt_FW_ARQ_NBIT)
      * ntt_N_SUP;
  else
    FW_TBIT = 0;

  if (ntt_FW_N_BIT_S_SCL[iscl] > 0)
    FW_TBIT_S =
      (ntt_FW_N_BIT_S_SCL[iscl]*ntt_FW_N_DIV_S_SCL[iscl]+ntt_FW_ARQ_NBIT) 
      * ntt_N_SHRT * ntt_N_SUP;
  else
    FW_TBIT_S = 0;

  if (ntt_FW_N_BIT_M_SCL[iscl] > 0)
    FW_TBIT_M =
      (ntt_FW_N_BIT_M_SCL[iscl]*ntt_FW_N_DIV_M_SCL[iscl]+ntt_FW_ARQ_NBIT)
      * ntt_N_MID * ntt_N_SUP;
  else
    FW_TBIT_M = 0;
    
  /*----------------------------------------------------------------------*/
  /* BITRATE CONTROL                                                      */
  /*----------------------------------------------------------------------*/
  {
    int bitfr_tmp, available_bits;
    int TSideInfo, TSideInfo_s, TSideInfo_m;
    int ndiv, vq_bits;

    /* Number of bits per frame */
    ntt_NBITS_FR_SCL[iscl] =
      ((int)(ntt_N_FR*ntt_N_SUP*ntt_BPS_SCL[iscl]/ntt_SAMPF));
    
    /* number of available bits */
    available_bits = ntt_NBITS_FR_SCL[iscl];
    bitfr_tmp = ((int)(ntt_N_FR*ntt_N_SUP*IBPS_tmp*1000./ntt_SAMPF));
    /* Number of bits for normalization tool */

    ntt_NMTOOL_BITS_SCL[iscl]   = LSP_TBIT+GAIN_TBIT+FW_TBIT+mat_SHIFT_BIT;
    ntt_NMTOOL_BITS_M_SCL[iscl] = LSP_TBIT+GAIN_TBIT_M+FW_TBIT_M+mat_SHIFT_BIT;
    ntt_NMTOOL_BITS_S_SCL[iscl] = LSP_TBIT+GAIN_TBIT_S+FW_TBIT_S+mat_SHIFT_BIT;

    /*
      ntt_NMTOOL_BITS_SCL[iscl] = LSP_TBIT + GAIN_TBIT + FW_TBIT;
      ntt_NMTOOL_BITS_M_SCL[iscl] = LSP_TBIT + GAIN_TBIT_M + FW_TBIT_M;
      ntt_NMTOOL_BITS_S_SCL[iscl] = LSP_TBIT + GAIN_TBIT_S + FW_TBIT_S;
    */
    /* Number of bits for side information */
    TSideInfo   = ntt_SIDE_INF_SW + ntt_PF_SW_BIT;
    TSideInfo_s = ntt_SIDE_INF_SW;
    TSideInfo_m = ntt_SIDE_INF_SW + ntt_PF_SW_BIT;
    /* set VQ codebook length (long) */
    vq_bits = bitfr_tmp - TSideInfo - ntt_NMTOOL_BITS_SCL[iscl];
    ntt_VQTOOL_BITS_SCL[iscl] = 
      available_bits - TSideInfo - ntt_NMTOOL_BITS_SCL[iscl];

    if (ntt_ISAMPF<=48){
      if( ntt_N_FR == 1024){
        ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
        ntt_CB_LEN_READ_SCL[iscl] = (int)((/*ntt_N_FR*/2048+(ndiv)-1)/ ndiv);
      }
      else if (ntt_N_FR == 960){
        ndiv = (int)((((2048*IBPS_tmp/48.)-TSideInfo
                       - ntt_NMTOOL_BITS_SCL[iscl]/ntt_N_SUP)+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
        ntt_CB_LEN_READ_SCL[iscl] = (int)((/*ntt_N_FR*/2048+ndiv-1)/ ndiv);
        fprintf(stderr, "%5d %5d FFF %5d\n", ndiv, ntt_CB_LEN_READ_SCL[iscl],
                iscl);
        ndiv  = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
      }
    }
    else{
      ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
      ntt_CB_LEN_READ_SCL[iscl]   = (int)((ntt_N_FR*ntt_N_SUP+(ndiv)-1)/ ndiv);
    }
    /* set VQ codebook length (medium) */
#if 0
    vq_bits = bitfr_tmp - TSideInfo_m - ntt_NMTOOL_BITS_M_SCL[iscl];
    ntt_VQTOOL_BITS_M_SCL[iscl] = 
      available_bits - TSideInfo_m - ntt_NMTOOL_BITS_M_SCL[iscl];
  
    if (ntt_ISAMPF<=48){
      if( ntt_N_FR == 1024){
        ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
        ntt_CB_LEN_READ_M_SCL[iscl]  = (int)((/*ntt_N_FR*/2048+(ndiv)-1)/ ndiv);
      }
      else if (ntt_N_FR == 960){
        ndiv = (int)((((2048*IBPS_tmp/48.)-TSideInfo_m
                       - ntt_NMTOOL_BITS_M_SCL[iscl]/ntt_N_SUP)+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
        ntt_CB_LEN_READ_M_SCL[iscl] = 
          (int)((/*ntt_N_FR*/2048*ntt_N_SUP+ndiv-1)/ ndiv);
        fprintf(stderr, "%5d %5d FFF %5d\n", 
                ndiv, ntt_CB_LEN_READ_M_SCL[iscl], iscl);
        ndiv  = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
      }
    }
    else{
      ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
      ntt_CB_LEN_READ_M_SCL[iscl] = (int)((ntt_N_FR*ntt_N_SUP+ndiv-1)/ ndiv);
    }
#endif
    /* set VQ codebook length (short) */
    vq_bits = bitfr_tmp - TSideInfo_s - ntt_NMTOOL_BITS_S_SCL[iscl];
    ntt_VQTOOL_BITS_S_SCL[iscl] = 
      available_bits - TSideInfo_s - ntt_NMTOOL_BITS_S_SCL[iscl];
    if (ntt_ISAMPF<=48){
      if( ntt_N_FR == 1024){
        ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
        ntt_CB_LEN_READ_S_SCL[iscl]  = (int)((/*ntt_N_FR*/2048+(ndiv)-1)/ ndiv);
      }
      else if (ntt_N_FR == 960){
        ndiv = (int)((((2048*IBPS_tmp/48.)-TSideInfo_s
                       - ntt_NMTOOL_BITS_S_SCL[iscl]/ntt_N_SUP)+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
        ntt_CB_LEN_READ_S_SCL[iscl] = 
          (int)((/*ntt_N_FR*/2048*ntt_N_SUP+ndiv-1)/ ndiv);
        fprintf(stderr, "%5d %5d FFF %5d\n", ndiv, ntt_CB_LEN_READ_S_SCL[iscl], iscl);
        ndiv  = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
      }
      ntt_CB_LEN_READ_S_SCL[iscl] =98; 
    }
    else{
      ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
      ntt_CB_LEN_READ_S_SCL[iscl] = (int)((ntt_N_FR*ntt_N_SUP+ndiv-1)/ ndiv);
    }
  }
  /*----------------------------------------------------------------------*/
  /* READING CODEBOOK TABLES                                              */
  /*----------------------------------------------------------------------*/
  if (iscl < cb_lyr){
    double *ptr0;
    int    cb_len_max;
    /*--- Interleaved vector quantization ---*/
    /* long frame */
    cb_len_max = ntt_CB_LEN_READ_SCL[iscl] + ntt_CB_LEN_MGN;
    ntt_codev0_scl[iscl] =
      (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
    ntt_codev1_scl[iscl] =
      (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
    ntt_get_cdbk(ntt_CB_NAME_SCL0[iscl], ntt_codev0_scl[iscl],
                 ntt_CB_SIZE, ntt_CB_LEN_READ_SCL[iscl], cb_len_max);
    ntt_get_cdbk(ntt_CB_NAME_SCL1[iscl], ntt_codev1_scl[iscl],
                 ntt_CB_SIZE, ntt_CB_LEN_READ_SCL[iscl], cb_len_max);
#if 0
    /* medium frame */
    cb_len_max = ntt_CB_LEN_READ_M_SCL[iscl] + ntt_CB_LEN_MGN;
    ntt_codev0m_scl[iscl] =
      (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
    ntt_codev1m_scl[iscl] =
      (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
    ntt_get_cdbk(ntt_CB_NAME_SCL0m[iscl], ntt_codev0m_scl[iscl],
                 ntt_CB_SIZE, ntt_CB_LEN_READ_M_SCL[iscl], cb_len_max);
    ntt_get_cdbk(ntt_CB_NAME_SCL1m[iscl], ntt_codev1m_scl[iscl],
                 ntt_CB_SIZE, ntt_CB_LEN_READ_M_SCL[iscl], cb_len_max);
#endif
    /* short frame */
    cb_len_max = ntt_CB_LEN_READ_S_SCL[iscl] + ntt_CB_LEN_MGN;
    ntt_codev0s_scl[iscl] =
      (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
    ntt_codev1s_scl[iscl] =
      (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
    ntt_get_cdbk(ntt_CB_NAME_SCL0s[iscl], ntt_codev0s_scl[iscl],
                 ntt_CB_SIZE, ntt_CB_LEN_READ_S_SCL[iscl], cb_len_max);
    ntt_get_cdbk(ntt_CB_NAME_SCL1s[iscl], ntt_codev1s_scl[iscl],
                 ntt_CB_SIZE, ntt_CB_LEN_READ_S_SCL[iscl], cb_len_max);
    /*--- Bark-scale envelope ---*/
    /* long frame */
    ntt_fwcodev_scl[iscl] =
      (double *)malloc(ntt_FW_CB_SIZE_SCL[iscl]*ntt_FW_CB_LEN_SCL[iscl]
                       *sizeof(double));
    ptr0 = ntt_fwcodev_scl[iscl];
    ntt_get_cdbk(ntt_FW_CB_NAME_SCL[iscl], ptr0,
                 ntt_FW_CB_SIZE_SCL[iscl],
                 ntt_FW_CB_LEN_SCL[iscl], ntt_FW_CB_LEN_SCL[iscl]);
#if 0
    /* medium frame */
    ntt_fwcodevm_scl[iscl] =
      (double *)malloc(ntt_FW_CB_SIZE_M_SCL[iscl]*ntt_FW_CB_LEN_M_SCL[iscl]
                       *sizeof(double));
    ptr0 = ntt_fwcodevm_scl[iscl];
    ntt_get_cdbk(ntt_FW_CB_NAME_M_SCL[iscl], ptr0,
                 ntt_FW_CB_SIZE_M_SCL[iscl],
                 ntt_FW_CB_LEN_M_SCL[iscl], ntt_FW_CB_LEN_M_SCL[iscl]);
#endif
    /* short frame */
    ntt_fwcodevs_scl[iscl] =
      (double *)malloc(ntt_FW_CB_SIZE_S_SCL[iscl]*ntt_FW_CB_LEN_S_SCL[iscl]
                       *sizeof(double));
    ptr0 = ntt_fwcodevs_scl[iscl];
    ntt_get_cdbk(ntt_FW_CB_NAME_S_SCL[iscl], ptr0,
                 ntt_FW_CB_SIZE_S_SCL[iscl],
                 ntt_FW_CB_LEN_S_SCL[iscl], ntt_FW_CB_LEN_S_SCL[iscl]);
  }
    ntt_BAND_LOWER_SCL[0] = 0.;
    ntt_BAND_UPPER_SCL[0] = min(1.0, 1.2* (double)IBPS_tmp/(double)ntt_ISAMPF);
    if(ntt_ISAMPF == 24) ntt_BAND_UPPER_SCL[0] = 2./3.;

}
