/**************************************************************************

This software module was originally developed by
Nokia in the course of development of the MPEG-2 AAC/MPEG-4 
Audio standard ISO/IEC13818-7, 14496-1, 2 and 3.
This software module is an implementation of a part
of one or more MPEG-2 AAC/MPEG-4 Audio tools as specified by the
MPEG-2 aac/MPEG-4 Audio standard. ISO/IEC  gives users of the
MPEG-2aac/MPEG-4 Audio standards free license to this software module
or modifications thereof for use in hardware or software products
claiming conformance to the MPEG-2 aac/MPEG-4 Audio  standards. Those
intending to use this software module in hardware or software products
are advised that this use may infringe existing patents. The original
developer of this software module, the subsequent
editors and their companies, and ISO/IEC have no liability for use of
this software module or modifications thereof in an
implementation. Copyright is not released for non MPEG-2 aac/MPEG-4
Audio conforming products. The original developer retains full right to
use the code for the developer's own purpose, assign or donate the code to a
third party and to inhibit third party from using the code for non
MPEG-2 aac/MPEG-4 Audio conforming products. This copyright notice
must be included in all copies or derivative works.
Copyright (c)1997.  

***************************************************************************/

#ifndef _NOK_LT_PREDICTION_H
#define _NOK_LT_PREDICTION_H

#include "nok_ltp_common.h"

/*
  Type:		NOK_LTP_DATA
  Purpose:	Type of the struct for passing the information
  		for prediction between the bitstream and the predictor
		routine.
  Explanation:	This is only used since we have to carry the data
  		from the bitstream a long way and want to do
		it nicely.  */
typedef struct
  {
    int sbk_prediction_used[NSHORT];
    int sfb_prediction_used[MAXBANDS];
    Float weight;
    int delay[NSHORT];
  } NOK_LTP_DATA;

extern void nok_init_lt_pred ( NOK_LT_PRED_STATUS * lt_status );

extern void nok_lt_predict ( int                 profile, 
                             Info*               info, 
                             WINDOW_TYPE         win_type,
                             Window_shape        win_shape,
                             int*                sbk_prediction_used, 
                             int*                sfb_prediction_used,
                             NOK_LT_PRED_STATUS* lt_status,
                             Float               weight, 
                             int*                delay, 
                             Float*              current_frame,
                             int                 block_size_long, 
                             int                 block_size_medium,
                             int                 block_size_short );

extern void nok_lt_decode ( WINDOW_TYPE       win_type, 
                            int               max_sfb,
                            int*              sbk_prediction_used, 
                            int*              sfb_prediction_used,
                            Float*            weight,
                            int*              delay,
                            HANDLE_RESILIENCE hResilience,
                            HANDLE_BUFFER     hVm, 
                            HANDLE_EP_INFO );

#endif /* not defined _NOK_LT_PREDICTION_H */
