/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Takeshi Norimatsu,                                                      */
/*   Mineo Tsushima,                                                         */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/* and edited by                                                             */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* and edited by                                                             */
/*   Mineo Tsushima,(Matsushita) on 1998-02-20,                              */
/*   Takehito Moriya,(NTT)       on 1998-05-01,                              */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/


#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"

void mat_scale_tf_requantize_spectrum(/* Input */
				      ntt_INDEX *indexp,
				      /* Output */
				      double flat_spectrum[],
				      /* scalable layer ID */
				      int iscl)
{
  int    vq_bits, n_sf, cb_len_max, nfr, isf, subtop;
  double *sp_cv0, *sp_cv1, spec_buf[ntt_T_FR_MAX];
  int qsample[ntt_N_SUP_MAX], bias[ntt_N_SUP_MAX];
  int i_ch;

  /*--- Parameter settings ---*/
  switch(indexp->w_type){
  case ONLY_LONG_WINDOW:
  case LONG_SHORT_WINDOW:
  case SHORT_LONG_WINDOW:
    /* available bits */
    vq_bits = ntt_VQTOOL_BITS_SCL[iscl];
    /* codebooks */
    sp_cv0 = (double *)ntt_codev0_scl[iscl];
    sp_cv1 = (double *)ntt_codev1_scl[iscl];
    cb_len_max = ntt_CB_LEN_READ_SCL[iscl] + ntt_CB_LEN_MGN;
    /* number of subframes in a frame */
    n_sf = ntt_N_SUP;
    nfr = ntt_N_FR;
    break;
  case ONLY_SHORT_WINDOW:
    /* available bits */
    vq_bits = ntt_VQTOOL_BITS_S_SCL[iscl];
    /* codebooks */
    sp_cv0 = (double *)ntt_codev0s_scl[iscl];
    sp_cv1 = (double *)ntt_codev1s_scl[iscl];
    cb_len_max = ntt_CB_LEN_READ_S_SCL[iscl] + ntt_CB_LEN_MGN;
    /* number of subframes in a frame */
    n_sf = ntt_N_SUP * ntt_N_SHRT;
    nfr = ntt_N_FR_S;
    break;
  default:
    fprintf(stderr, "ntt_scale_tf_requantize_spectrum(): %d: No such window type.\n",
	    indexp->w_type);
    exit(1);
  }

  /*--- Reconstruction ---*/
  ntt_vex_pn(indexp->wvq,
	     sp_cv0, sp_cv1, cb_len_max,
	     n_sf, ntt_N_FR*ntt_N_SUP,
	     vq_bits,
	     flat_spectrum);
    if(iscl==0){
      for(i_ch = 0; i_ch<ntt_N_SUP; i_ch++){
        mat_shift[iscl][i_ch] =0; 
      }
    }
    else if(iscl >= 1){
      ntt_zerod(ntt_N_FR*ntt_N_SUP,spec_buf);  /* Tsushima */
      for(i_ch = 0; i_ch<ntt_N_SUP; i_ch++){
        qsample[i_ch]=nfr*(ntt_AC_TOP[iscl][i_ch][mat_shift[iscl][i_ch]]
		  -   ntt_AC_BTM[iscl][i_ch][mat_shift[iscl][i_ch]]);
        bias[i_ch] =  nfr *ntt_AC_BTM[iscl][i_ch][mat_shift[iscl][i_ch]];
      }
      for(isf=0;isf<n_sf;isf++){
        subtop= isf*nfr;
	i_ch = subtop/ntt_N_FR;
        ntt_movdd(qsample[i_ch],flat_spectrum+subtop,
				spec_buf+subtop+bias[i_ch]);
      }
      ntt_movdd(ntt_N_FR*ntt_N_SUP,spec_buf,flat_spectrum); /* Tsushima */
   }
}
