/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Takeshi Norimatsu,                                                      */
/*   Mineo Tsushima,                                                         */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/* and edited by                                                             */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"

/* For Enh-2 moving */
int mat_scale_set_shift_para2(int iscl)
{
	int ii;
	double band_l, band_ref;

     if(ntt_N_FR==1024)
	{
	/* 24kHz 1024pt enh-2 moving */
	band_l= ntt_AC_BTM[iscl][0][mat_shift[iscl][0]];
	band_ref= ntt_AC_BTM[1][0][mat_shift[1][0]];
	if(iscl>=2) {
	/* Long */
 	ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_1024_3rd;
		for(ii=0;ii<ntt_N_CRB_24_1024_3rd;ii++){
		ntt_crb_tbl_scl[iscl][ii] =
		(int)(((band_l-band_ref)
		*ntt_N_FR )+ ntt_crb_tbl_24_1024_3rd[ii]);
		}
	/* Short */
        ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
		for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
		ntt_crb_tbl_s_scl[iscl][ii]
		= (int)(((band_l-band_ref)
		*ntt_N_FR/ntt_N_SHRT) + ntt_crb_tbl_s_24_64_3rd[ii]);
		}
        }
	else if(iscl==1) {
	band_l= ntt_AC_BTM[iscl][0][mat_shift[iscl][0]];
	band_ref= ntt_AC_BTM[1][0][mat_shift[1][0]];
	/* Long */
		ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_1024_3rd;
		for(ii=0;ii<ntt_N_CRB_24_1024_3rd;ii++){
		ntt_crb_tbl_scl[iscl][ii] =
		(int)(((band_l - 1./3.)*ntt_N_FR )+ 
		ntt_crb_tbl_24_1024_3rd[ii]);
		}
	/* Short */
		ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
		for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
		ntt_crb_tbl_s_scl[iscl][ii]
          	= (int)(((band_l - 1./3.) 
		*ntt_N_FR/ntt_N_SHRT) + ntt_crb_tbl_s_24_64_3rd[ii]);
	        }
 	 }
     }
     else if(ntt_N_FR==960) {
	/* 24kHz 960pt enh-2 moving */
	if(iscl>=2) {
	band_l= ntt_AC_BTM[iscl][0][mat_shift[iscl][0]];
	band_ref= ntt_AC_BTM[1][0][mat_shift[1][0]];
	/* Long */
	    ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_960_3rd;
		for(ii=0;ii<ntt_N_CRB_24_1024_3rd;ii++){
		ntt_crb_tbl_scl[iscl][ii] =
		 (int)(((band_l-band_ref)
		*ntt_N_FR )+ ntt_crb_tbl_24_960_3rd[ii]);
	        }
	/* Short */
	   ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
		for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
		ntt_crb_tbl_s_scl[iscl][ii]
		= (int)(((band_l-band_ref)
		*ntt_N_FR/ntt_N_SHRT) + ntt_crb_tbl_s_24_64_3rd[ii]);
	  }
	}
	else if(iscl==1) {
	band_l= ntt_AC_BTM[iscl][0][mat_shift[iscl][0]];
	band_ref= ntt_AC_BTM[1][0][mat_shift[1][0]];
	/* Long */
	   ntt_N_CRB_SCL[iscl] = ntt_N_CRB_24_960_3rd;
	       for(ii=0;ii<ntt_N_CRB_24_1024_3rd;ii++){
	       ntt_crb_tbl_scl[iscl][ii] =
		(int)(((band_l - 1./3.)*ntt_N_FR )+
		ntt_crb_tbl_24_960_3rd[ii]);
	       }
	/* Short */
		ntt_N_CRB_S_SCL[iscl] = ntt_N_CRB_S_24_64_3rd;
		for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
		ntt_crb_tbl_s_scl[iscl][ii]
		= (int)(((band_l - 1./3.)
		*ntt_N_FR/ntt_N_SHRT) + ntt_crb_tbl_s_24_64_3rd[ii]);
	        }
        }
      }
	
	return(0);
}

#ifdef __cplusplus
}
#endif
