/*****************************************************************************
 *                                                                           *
 * This software module was originally developed by                          *
 *                                                                           *
 * Ralph Sperschneider (Fraunhofer Institute for Integrated Circuits)        *
 *                                                                           *
 * and edited by                                                             *
 *                                                                           *
 * Pierre Lauber (Fraunhofer Institute for Integrated Circuits)              *
 *                                                                           *
 * !!! This software is FhG IIS propriatery !!!                              *
 *                                                                           *
 * Copyright(c)1998.                                                         *
 *                                                                           *
 ****************************************************************************/
 
#include "all.h"
#include "tf_main.h"
#include "resilience.h"

typedef struct tag_concealment *HANDLE_CONCEALMENT;

/* HANDLE_CONCEALMENT hConcealment */ void ConcealmentInit();
void ConcealmentSetChannel(/* HANDLE_CONCEALMENT hConcealment */ int channel);
void ConcealmentHelp(/* HANDLE_CONCEALMENT hConcealment */ FILE *helpStream);
void ConcealmentParseCmdline(/* HANDLE_CONCEALMENT hConcealment */ char * decPara);
void ConcealmentCheckLengthOfSpectralData(int        beginSpectralDataBitCnt,
                                          int        endSpectralDataBitCnt,
                                          HANDLE_HCR hHcrInfo
                                       /* HANDLE_CONCEALMENT hConcealment */);
void ConcealmentDetectError1(int            step,
                             unsigned char  codewordLength,
                             byte*          qpStatus,
                             Hcb*           hcb,
                             HANDLE_HCR     hHcrInfo);
void ConcealmentDetectError2(unsigned short step,
                             unsigned char  codewordLength,
                             unsigned char  *qpStatus,
                             Hcb*           hcb,
                             HANDLE_HCR     hHcrInfo);
void ConcealmentDetectError3(unsigned short step,
                             unsigned char  codewordLength,
                             unsigned char  *qpStatus,
                             unsigned char  maxCWLength, 
                             unsigned char  segmentWidth,
                             HANDLE_HCR     hHcrInfo);
void ConcealmentDetectError4(unsigned short step,
                             unsigned char  *qpStatus);
void ConcealmentDetectError5(unsigned short step,
                             unsigned char  *qpStatus,
                             unsigned char  *invalid);
void ConcealmentMainEntry ( int ch,
                            byte blockType, 
                            float *coef, 
                            Info *info,
                            HANDLE_EP_INFO hEPInfo
                         /* HANDLE_CONCEALMENT hConcealment */);
void ConcealmentSetCoeffStatus ( byte               quantStatus[], 
                                 Info*              info,
                                 HANDLE_RESILIENCE  hResilience
                              /* HANDLE_CONCEALMENT hConcealment */);
void Concealment1(unsigned short step,
                  int            *qp);
