/*****************************************************************************
 *                                                                           *
"This software module was originally developed by 

Ralph Sperschneider (Fraunhofer Gesellschaft IIS)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1998.
 *                                                                           *
 ****************************************************************************/
#ifndef _buffers_h_
#define _buffers_h_

/* definitions */

/* code table for aac bitstream elements */
typedef enum {
  ID_SYN_ELE = 0,
  ELEMENT_INSTANCE_TAG = 1,
  GLOBAL_GAIN_MSB_1_5 = 2,
  GLOBAL_GAIN_MSB_6_7 = 3,
  GLOBAL_GAIN_MSB_8 = 4,
  WINDOW_SEQUENCE_CODE = 5,
  WINDOW_SHAPE = 6,
  MAX_SFB = 7,
  PREDICTOR_DATA_PRESENT = 8,
  PREDICTOR_RESET = 9,
  PREDICTOR_RESET_GROUP_NUMBER = 10,
  PREDICTION_USED = 11,
  SECT_CB = 12,
  SECT_LEN_INCR = 13,
  HCOD_SF = 14,
  PULSE_DATA_PRESENT = 15,
  NUMBER_PULSE = 16,
  PULSE_START_OFFSET = 17,
  PULSE_OFFSET = 18,
  PULSE_AMP = 19,
  TNS_DATA_PRESENT = 20,
  N_FILT = 21,
  COEF_RES = 22,
  TNS_LENGTH = 23,
  ORDER = 24,
  DIRECTION = 25,
  COEF_COMPRESS = 26,
  TNS_COEF = 27,
  GAIN_CONTROL_DATA_PRESENT = 28,
  MAX_BAND = 29,
  ADJUST_NUM = 30,
  ALEVCODE = 31,
  ALOCCODE = 32,
  HCOD = 33,
  SIGN_BITS = 34,
  ESCAPE_BITS = 35,
  COMMON_WINDOW = 36,
  MS_MASK_PRESENT = 37,
  MS_USED = 38,
  DATA_BYTE_ALIGN_FLAG = 39,
  COUNT = 40,
  ESC_COUNT = 41,
  DATA_STREAM_BYTE = 42,
  FILL_BYTE = 43,
  LENGTH_OF_LONGEST_CODEWORD = 44,
  LENGTH_OF_SPECTRAL_DATA = 45,
  ICS_RESERVED = 46,
  SCALE_FACTOR_GROUPING = 47,
  PCM_BITS = 48,
  PROFILE = 49,
  SAMPLING_FREQUENCY_INDEX = 50,
  NUM_FRONT_CHANNEL_ELEMENTS = 51,
  NUM_SIDE_CHANNEL_ELEMENTS = 52,
  NUM_BACK_CHANNEL_ELEMENTS = 53,
  NUM_LFE_CHANNEL_ELEMENTS = 54,
  NUM_ASSOC_DATA_ELEMENTS = 55,
  NUM_VALID_CC_ELEMENTS = 56,
  MONO_MIXDOWN_PRESENT = 57,
  MONO_MIXDOWN_ELEMENT_NUMBER = 58,
  STEREO_MIXDOWN_PRESENT = 59,
  STEREO_MIXDOWN_ELEMENT_NUMBER = 60,
  MATRIX_MIXDOWN_IDX_PRESENT = 61,
  MATRIX_MIXDOWN_IDX = 62,
  PSEUDO_SURROUND_ENABLE = 63,
  FRONT_ELEMENT_IS_CPE = 64,
  FRONT_ELEMENT_TAG_SELECT = 65,
  COMMENT_FIELD_BYTES = 74,
  COMMENT_FIELD_DATA = 75,
  ADIF_ID = 76,
  COPYRIGHT_ID_PRESENT = 77,
  COPYRIGHT_ID = 78,
  ORIGINAL_COPY = 79,
  HOME = 80,
  BITSTREAM_TYPE = 81,
  BITRATE = 82,
  NUM_PROGRAM_CONFIG_ELEMENTS = 83,
  ADIF_BUFFER_FULLNESS = 84,
  IND_SW_CCE_FLAG = 85,
  NUM_COUPLED_ELEMENTS = 86,
  CC_TARGET_IS_CPE = 87,
  CC_TARGET_TAG_SELECT = 88,
  CC_L = 89,
  CC_R = 90,
  CC_DOMAIN = 91,
  GAIN_ELEMENT_SIGN = 92,
  GAIN_ELEMENT_SCALE = 93,
  COMMON_GAIN_ELEMENT_PRESENT = 94,
  NOK_DATA = 98,
  ALIGN_BITS = 99
} CODE_TABLE;

enum {
  VIRTUELL               = 0,
  MAX_CW_LENGTH          = 49,
  AAC_MAX_INPUT_BUF_BITS = 12288
};

typedef struct  tag_buffer  *HANDLE_BUFFER;

#include "bitstream.h"
#include "resilience.h"

/* fuction declarations */ 

HANDLE_BUFFER  CreateBuffer ( unsigned long bufferSize );

#ifdef VERSION2

void           FinishWriting ( HANDLE_BUFFER handle );

#endif

unsigned long  GetReadBitCnt( HANDLE_BUFFER handle );

long           GetBits ( CODE_TABLE        code,
                         int               n,
                         HANDLE_RESILIENCE hResilience,
                         HANDLE_BUFFER     hVm,
                         HANDLE_EP_INFO    hEPInfo );

#ifdef VERSION2

void           PrepareReading ( HANDLE_BUFFER handle );

void           PrepareWriting ( HANDLE_BUFFER handle );

void PutBits ( int               n,
               HANDLE_BUFFER     handle,
               unsigned long     value );

#endif /* VERSION2 */

void           ResetReadBitCnt ( HANDLE_BUFFER handle );

void           ResetWriteBitCnt ( HANDLE_BUFFER handle );

void           RestoreBufferPointer ( HANDLE_BUFFER handle );

void           StoreBufferPointer ( HANDLE_BUFFER handle );

void           StoreDataInBuffer ( HANDLE_BUFFER  fromHandle,
                                   HANDLE_BUFFER  toHandle,
                                   unsigned short nrOfBits );

#ifdef VERSION2
 
void           TransferBits ( HANDLE_BUFFER     fromHandle,
                              HANDLE_BUFFER     toHandle,
                              unsigned long     nrOfBits,
                              HANDLE_RESILIENCE hResilience,
                              HANDLE_EP_INFO    hEPInfo );

#endif

void           setHuffdec2BitBuffer ( BsBitStream* fixed_stream );

void            byte_align ( void ); /* make it void */

#endif /* _buffers_h_  */
