/*====================================================================*/
/*         MPEG-4 Audio (ISO/IEC 14496-3) Copyright Header            */
/*====================================================================*/
/*
This software module was originally developed by Rakesh Taori and Andy
Gerrits (Philips Research Laboratories, Eindhoven, The Netherlands) in
the course of development of the MPEG-4 Audio (ISO/IEC 14496-3). This
software module is an implementation of a part of one or more MPEG-4
Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC
14496-3) free license to this software module or modifications thereof
for use in hardware or software products claiming conformance to the
MPEG-4 Audio (ISO/IEC 14496-3). Those intending to use this software
module in hardware or software products are advised that its use may
infringe existing patents. The original developer of this software
module and his/her company, the subsequent editors and their
companies, and ISO/IEC have no liability for use of this software
module or modifications thereof in an implementation. Copyright is not
released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming products.
CN1 retains full right to use the code for his/her own purpose, assign
or donate the code to a third party and to inhibit third parties from
using the code for non MPEG-4 Audio (ISO/IEC 14496-3) conforming
products.  This copyright notice must be included in all copies or
derivative works. Copyright 1996.
*/
/*====================================================================*/
/*====================================================================*/
/*                                                                    */
/*      INCLUDE_FILE:   PHI_BS2P.H                                    */
/*      PACKAGE:        WDBxx                                         */
/*      COMPONENT:      Bitstream to Parameter converter              */
/*                                                                    */
/*====================================================================*/
/*======================================================================*/
/*      G L O B A L  F U N C T I O N  P R O T O T Y P E S               */
/*======================================================================*/

#ifndef _phi_bs2p_h_
#define _phi_bs2p_h_


#ifdef __cplusplus
extern "C" {
#endif


/*======================================================================*/
/*   Function Prototype: celp_bitstream_demux                           */
/*======================================================================*/
void 
    celp_bitstream_demux(             
    BITSTREAM  * const p_bitstream,  /* In:  Bitstream                  */
    long * const signal_mode,        /* Out: Signal mode (NOT USED)     */
    long frame_bit_allocation[],     /* In:  Bit Alloc.                 */ 
    long * const interpol,           /* Out: Interpolation flag         */
    const long num_lpc_indices,      /* In: Number of packed LPC        */
    long lpc_indices[],              /* Out: LP coefficients            */
    long * const rms_index,          /* Out: RMS index (NOT USED)       */
    long shape_indices[],            /* Out: Shape indices              */
    long gain_indices[],             /* Out: Gain indices               */
    const long num_shape_cbks,       /* In: Number of Shape Codebooks   */
    const long num_gain_cbks,        /* In: Number of Gain Codebooks    */
    const long n_sbfrms              /* In:  Number of subframes        */
    );


#ifdef __cplusplus
}
#endif

#endif  /* #ifndef _phi_bs2p_h_ */


/*======================================================================*/
/*      H I S T O R Y                                                   */
/*======================================================================*/
/* 07-06-96  R. Taori & A.Gerrits    Initial Version                    */
/* 18-09-96  R. Taori & A.Gerrits    MPEG bitstream used                */
