/*


This software module was originally developed by

Peter Kroon (Bell Laboratories, Lucent Technologies)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1996.


 * Last modified: May 1, 1996
 *
 */
#define MAXORDER 20
#define ALMOST1 0.999	/* a number slightly less than 1 */
#include <stdio.h>

/*----------------------------------------------------------------------------
 * pc2rc - lpc Predictor Coefficient to Reflection Coefficient conversion
 *
 * IMPLEMENTATION NOTES:
 *	This version does not overwrite the input LPC predictor coefficient
 *	array as some other versions does.  Also, it gives a warning message
 * 	if any of the output reflection coefficients has a magnitude greater 
 *	than a defined constant "ALMOST1", which is currently set at 0.999. 
 *	And, if this happens, that reflection coefficient is clipped to
 *	either ALMOST1 or -ALMOST1, depending of its sign.
 *	This is to ensure that the corresponding LPC filter is stable.
 *----------------------------------------------------------------------------
 */
long pc2rc(		/* output: 1 = normal return; 0 = rc[] clipped */
float *rc,		/* output: reflection coefficients */
const float *a,		/* input : LPC coefficients */
long order		/* input : LPC order */
)
{
    long i, j, ret;
    float aa[MAXORDER + 1], temp[MAXORDER + 1], tmp;
   
    testbound(order, MAXORDER, "pc2rc.c");
/* 06/29/96
    for (i = 0; i <= order; i++)
	aa[i] = a[i];		 make a local copy to avoid overwriting a[]*/
	aa[0] = 1.0;
	for(i=1;i<=order;i++) aa[i] = a[i-1];

    ret = 1;
    for (i = order; i > 0; i--) {
      tmp = 1.0 - aa[i] * aa[i];
      for (j = 0; j < i; j++)
	temp[j] = aa[i-j];
      for (j = 0; j < i; j++)
	aa[j] = (aa[j] - aa[i] * temp[j])/tmp;
      rc[i-1] = aa[i];
      /* CHECK IF rc[] IS WITHIN STABILITY BOUND */
      if (rc[i-1] > ALMOST1) { 
	printf("pc2rc: LPC filter unstable!  rc[%d] = %f\n",i-1,rc[i-1]); 
	rc[i-1] = ALMOST1;
	ret = 0;
      }
      if (rc[i-1] < - ALMOST1) { 
	printf("pc2rc: LPC filter unstable!  rc[%d] = %f\n",i-1,rc[i-1]); 
	rc[i-1] = - ALMOST1;
	ret = 0;
      }
    }
    return(ret);
}
