/*****************************************************************************
 *                                                                           *
"This software module was originally developed by 

Ralph Sperschneider (Fraunhofer Gesellschaft IIS)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1998.
 *                                                                           *
 ****************************************************************************/

#include <stdlib.h>
#include <string.h>
#ifdef VERSION2
#include "resilience.h"

typedef struct tag_resilience
{
  char epFlag;
  char aacLenOfLongestCwFlag;
  char aacReorderSpecFlag;
} T_RESILIENCE;

HANDLE_RESILIENCE CreateErrorResilience ( char* decPara, int epFlag )
{
  HANDLE_RESILIENCE handle;
  handle = (HANDLE_RESILIENCE) malloc(sizeof(T_RESILIENCE));
  handle->epFlag = ( epFlag ? 1 : 0 );
  handle->aacLenOfLongestCwFlag = 0;
  handle->aacReorderSpecFlag    = 0;
  if ( strstr ( decPara, "-aac_raw" ) || strstr ( decPara, "-aac_sca" ) )
    { 
      handle->aacLenOfLongestCwFlag = ( ( strstr ( decPara, "-lcw" ) ) || ( strstr ( decPara, "-hcr" ) ) ? 1 : 0 );
      handle->aacReorderSpecFlag = ( ( strstr ( decPara, "-hcr" ) ) ? 1 : 0 );
    }
  return ( handle );
}

char GetEPFlag ( HANDLE_RESILIENCE handle )
{
  return ( handle->epFlag );
}

/* aac only */

char GetLenOfLongestCwFlag ( HANDLE_RESILIENCE handle )
{
  return ( handle->aacLenOfLongestCwFlag );
}

char GetReorderSpecFlag ( HANDLE_RESILIENCE handle )
{
  return ( handle->aacReorderSpecFlag );
}
#endif /*VERSION2*/
