// cpages.c : implementation file
//

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>	// for sprintf()

#include "imdefs.h"
#include "txdefs.h"

#include "ccore.h"

#include "cresourc.h"
#include "cpages.h"

/////////////////////////////////////////////////////////////////////////////
// Imagine interface functions

LPARAM	lCreateArg;	// required for 'ccore.c'

void *CreatePages(LPARAM lCreateArg, TXHOSTINFO *pHost, float *params)
{
	struct PageData	*pPageData = malloc(sizeof(struct PageData));

	if (!pPageData)
		return NULL;

	memcpy(pPageData->params, params, 16*sizeof(float));

	pPageData->pHost = pHost;

	// Copy defaults into page variables
	pPageData->fXSize = params[0];
	pPageData->fYSize = params[1];
	pPageData->fZSize = params[2];

	pPageData->fBlend1 = params[3];
	pPageData->fBlend2 = params[4];
	pPageData->fBlend3 = params[5];
	pPageData->fBlend4 = params[6];

	pPageData->Color1 = RGB((int)params[7],(int)params[8],(int)params[9]);
	pPageData->Color2 = RGB((int)params[10],(int)params[11],(int)params[12]);
	pPageData->Color3 = RGB((int)params[13],(int)params[14],(int)params[15]);

	if (AddPSPage(pHost, MAKEINTRESOURCE(IDD_COLOR),
		ColorPageProc, pPageData, MAKEINTRESOURCE(IDD_COLOR)))
	{
		if (AddPSPage(pHost, MAKEINTRESOURCE(IDD_SIZE),
			SizePageProc, pPageData, MAKEINTRESOURCE(IDD_SIZE)))
		{
			if (AddPSPage(pHost, MAKEINTRESOURCE(IDD_CONTROLS),
				ControlsPageProc, pPageData, MAKEINTRESOURCE(IDD_CONTROLS)))
			{
				if (AddPSPage(pHost, MAKEINTRESOURCE(IDD_INFO),
					InfoPageProc, pPageData, MAKEINTRESOURCE(IDD_INFO)))
				{
					return pPageData;
				}
				RemovePSPage(pHost, MAKEINTRESOURCE(IDD_CONTROLS));
			}
			RemovePSPage(pHost, MAKEINTRESOURCE(IDD_SIZE));
		}
		RemovePSPage(pHost, MAKEINTRESOURCE(IDD_COLOR));
	}

	free(pPageData);

	return NULL;
}

void ReleasePages(void *pClientData)
{
	free(pClientData);
}

void StoreParams(void *pClientData, float *params)
{
	struct PageData	*pPageData = (struct PageData *)pClientData;

	pPageData->params[0] = pPageData->fXSize;
	pPageData->params[1] = pPageData->fYSize;
	pPageData->params[2] = pPageData->fZSize;

	pPageData->params[3] = pPageData->fBlend1;
	pPageData->params[4] = pPageData->fBlend2;
	pPageData->params[5] = pPageData->fBlend3;
	pPageData->params[6] = pPageData->fBlend4;

	pPageData->params[7] = GetRValue(pPageData->Color1);
	pPageData->params[8] = GetGValue(pPageData->Color1);
	pPageData->params[9] = GetBValue(pPageData->Color1);

	pPageData->params[10] = GetRValue(pPageData->Color2);
	pPageData->params[11] = GetGValue(pPageData->Color2);
	pPageData->params[12] = GetBValue(pPageData->Color2);

	pPageData->params[13] = GetRValue(pPageData->Color3);
	pPageData->params[14] = GetGValue(pPageData->Color3);
	pPageData->params[15] = GetBValue(pPageData->Color3);

	memcpy(params, pPageData->params, 16 * sizeof(float));
}

//  --->  Property Page Code <----

/////////////////////////////////////////////////////////////////////////////
// ColorPage property page WindowProc

LRESULT	CALLBACK ColorPageProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	struct PageData *pData;

	if (pNextPageData) {
		pData = (struct PageData *)pNextPageData;
		pNextPageData = NULL;
		SetWindowLong(hwnd, DWL_USER, (LONG)pData);
	} else {
		pData = (struct PageData *)GetWindowLong(hwnd, DWL_USER);
	}

	switch (uMsg) {

	case WM_NOTIFY:

		{
			NMHDR	*pnmh = (NMHDR *)lParam;

			switch(pnmh->code) {

			case PSN_SETACTIVE:
				SubclassColorButton(pData->pHost, hwnd, IDC_COLOR1, pData->Color1);
				SubclassColorButton(pData->pHost, hwnd, IDC_COLOR2, pData->Color2);
				SubclassColorButton(pData->pHost, hwnd, IDC_COLOR3, pData->Color3);
				SetWindowLong(hwnd, DWL_MSGRESULT, 0);
				return TRUE;
				
			case PSN_KILLACTIVE:
				GetButtonColor(pData->pHost, hwnd, IDC_COLOR1, &pData->Color1);
				GetButtonColor(pData->pHost, hwnd, IDC_COLOR2, &pData->Color2);
				GetButtonColor(pData->pHost, hwnd, IDC_COLOR3, &pData->Color3);
				SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
				return TRUE;

			default:
				return FALSE;
			}
		}
		break;

	case WM_DRAWITEM:

		switch(wParam) {
		case IDC_COLOR1:
		case IDC_COLOR2:
		case IDC_COLOR3:
			return SendMessage(GetDlgItem(hwnd, wParam), WM_DRAWITEM, wParam, lParam);
			break;
		}

		// else default to DefWindowProc
		break;

	case WM_COMMAND:

		if (HIWORD(wParam) == BN_CLICKED) {
			switch(LOWORD(wParam)) {
			case IDC_COLOR1:
				OnColorButton(pData->pHost, hwnd, IDC_COLOR1, &pData->Color1);
				return 0;
			case IDC_COLOR2:
				OnColorButton(pData->pHost, hwnd, IDC_COLOR2, &pData->Color2);
				return 0;
			case IDC_COLOR3:
				OnColorButton(pData->pHost, hwnd, IDC_COLOR3, &pData->Color3);
				return 0;
			}
		}

		// else default to DefWindowProc
		break;
	}

	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////
// SizePage property page WindowProc

LRESULT	CALLBACK SizePageProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	struct PageData *pData;

	if (pNextPageData) {
		pData = (struct PageData *)pNextPageData;
		pNextPageData = NULL;
		SetWindowLong(hwnd, DWL_USER, (LONG)pData);
	} else {
		pData = (struct PageData *)GetWindowLong(hwnd, DWL_USER);
	}

	switch (uMsg) {

	case WM_NOTIFY:

		{
			NMHDR	*pnmh = (NMHDR *)lParam;

			switch(pnmh->code) {

			case PSN_SETACTIVE:
				{
					char	szTmp[64];
					int	nPos;

					pData->bLocked = TRUE;

					nPos = (int)pData->fXSize;
					if (nPos < 0)
						nPos = 1;
					if (nPos > 16484)
						nPos = 16384;

					SendDlgItemMessage(hwnd, IDC_XSIZE_SPIN,
						UDM_SETRANGE, 0, MAKELONG(16384,0));
					SendDlgItemMessage(hwnd, IDC_XSIZE_SPIN,
						UDM_SETPOS, 0, nPos);

					SendDlgItemMessage(hwnd, IDC_XSIZE_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,16384));
					SendDlgItemMessage(hwnd, IDC_XSIZE_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fXSize);
					SetDlgItemText(hwnd, IDC_XSIZE_EDIT, szTmp);

					nPos = (int)pData->fYSize;
					if (nPos < 0)
						nPos = 1;
					if (nPos > 16484)
						nPos = 16384;

					SendDlgItemMessage(hwnd, IDC_YSIZE_SPIN,
						UDM_SETRANGE, 0, MAKELONG(16384,0));
					SendDlgItemMessage(hwnd, IDC_YSIZE_SPIN,
						UDM_SETPOS, 0, nPos);

					SendDlgItemMessage(hwnd, IDC_YSIZE_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,16384));
					SendDlgItemMessage(hwnd, IDC_YSIZE_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fYSize);
					SetDlgItemText(hwnd, IDC_YSIZE_EDIT, szTmp);

					nPos = (int)pData->fZSize;
					if (nPos < 0)
						nPos = 1;
					if (nPos > 16484)
						nPos = 16384;

					SendDlgItemMessage(hwnd, IDC_ZSIZE_SPIN,
						UDM_SETRANGE, 0, MAKELONG(16384,0));
					SendDlgItemMessage(hwnd, IDC_ZSIZE_SPIN,
						UDM_SETPOS, 0, nPos);

					SendDlgItemMessage(hwnd, IDC_ZSIZE_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,16384));
					SendDlgItemMessage(hwnd, IDC_ZSIZE_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fZSize);
					SetDlgItemText(hwnd, IDC_ZSIZE_EDIT, szTmp);

					pData->bLocked = FALSE;

					SetWindowLong(hwnd, DWL_MSGRESULT, 0);
					return TRUE;
				}
				break;
				
			case PSN_KILLACTIVE:
				{
					char	szTmp[64];
					HWND	hwndCtrl;
					float	fTmp;

					szTmp[64] = 0;

					hwndCtrl = GetDlgItem(hwnd, IDC_XSIZE_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1) {
numerr:					MessageBox(hwnd, "Please enter a number.", NULL, MB_OK);
						SetFocus(hwndCtrl);
						SetWindowLong(hwnd, DWL_MSGRESULT, TRUE);
						return TRUE;
					}

					pData->fXSize = fTmp;

					hwndCtrl = GetDlgItem(hwnd, IDC_YSIZE_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1)
						goto numerr;

					pData->fYSize = fTmp;

					hwndCtrl = GetDlgItem(hwnd, IDC_ZSIZE_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1)
						goto numerr;

					pData->fZSize = fTmp;

					SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
					return TRUE;
				}
				break;
			}
		}

		// else, "not handled"
		return FALSE;

	case WM_COMMAND:

		if (HIWORD(wParam) == EN_UPDATE) {
			if (!pData->bLocked) {
				switch(LOWORD(wParam)) {
				case IDC_XSIZE_EDIT:
				case IDC_YSIZE_EDIT:
				case IDC_ZSIZE_EDIT:
					SendMessage(GetParent(hwnd), PSM_CHANGED, (WPARAM)hwnd, 0);
					return 0;
				}
			}
			break;
		}

		if (HIWORD(wParam) == EN_CHANGE) {
			if (!pData->bLocked) {

				int	nCtrlID2 = 0;
				int	nCtrlID3 = 0;

				switch(LOWORD(wParam)) {
				case IDC_XSIZE_EDIT:
					nCtrlID2 = IDC_XSIZE_SPIN;
					nCtrlID3 = IDC_XSIZE_SLIDE;
					break;
				case IDC_YSIZE_EDIT:
					nCtrlID2 = IDC_YSIZE_SPIN;
					nCtrlID3 = IDC_YSIZE_SLIDE;
					break;
				case IDC_ZSIZE_EDIT:
					nCtrlID2 = IDC_ZSIZE_SPIN;
					nCtrlID3 = IDC_ZSIZE_SLIDE;
					break;
				}

				if (nCtrlID2) {

					char	szTmp[64];
					float	fTmp;
					int	nPos = 0;

					szTmp[63] = 0;

					pData->bLocked = TRUE;

					GetDlgItemText(hwnd, LOWORD(wParam), szTmp, 63);
					if (sscanf(szTmp, " %f", &fTmp) == 1)
						nPos = (int)fTmp;

					SendDlgItemMessage(hwnd, nCtrlID2, UDM_SETPOS, 0, MAKELONG(nPos,0));
					SendDlgItemMessage(hwnd, nCtrlID3, TBM_SETPOS, TRUE, nPos);

					pData->bLocked = FALSE;
				}
			}
		}

		// else default to DefWindowProc
		break;

	case WM_HSCROLL:
	case WM_VSCROLL:

		if (!pData->bLocked) {

			int	nCtrlID;
			int	nCtrlID2 = 0;
			int	nCtrlID3 = 0;
			HWND	hwndCtrl;

			pData->bLocked = TRUE;

			hwndCtrl = (HWND)lParam;		// handle of control
			nCtrlID = GetDlgCtrlID(hwndCtrl);

			switch(nCtrlID) {
			case IDC_XSIZE_SPIN:
				nCtrlID = IDC_XSIZE_EDIT;
				nCtrlID2 = IDC_XSIZE_SLIDE;
				break;

			case IDC_YSIZE_SPIN:
				nCtrlID = IDC_YSIZE_EDIT;
				nCtrlID2 = IDC_YSIZE_SLIDE;
				break;

			case IDC_ZSIZE_SPIN:
				nCtrlID = IDC_ZSIZE_EDIT;
				nCtrlID2 = IDC_ZSIZE_SLIDE;
				break;

			case IDC_XSIZE_SLIDE:
				nCtrlID = IDC_XSIZE_EDIT;
				nCtrlID3 = IDC_XSIZE_SPIN;
				break;

			case IDC_YSIZE_SLIDE:
				nCtrlID = IDC_YSIZE_EDIT;
				nCtrlID3 = IDC_YSIZE_SPIN;
				break;

			case IDC_ZSIZE_SLIDE:
				nCtrlID = IDC_ZSIZE_EDIT;
				nCtrlID3 = IDC_ZSIZE_SPIN;
				break;

			default:
				pData->bLocked = FALSE;
				break;
			}

			if (pData->bLocked) {

				char	buf[64];
				int	nPos;

				if (nCtrlID2) {
					nPos = (WORD)SendMessage(hwndCtrl, UDM_GETPOS, 0, 0);
					SendDlgItemMessage(hwnd, nCtrlID2, TBM_SETPOS, TRUE, nPos);
				} else {
					nPos = SendMessage(hwndCtrl, TBM_GETPOS, 0, 0);
					SendDlgItemMessage(hwnd, nCtrlID3, UDM_SETPOS, 0, MAKELONG(nPos,0));
				}

				sprintf(buf, "%f", (float)nPos);
				SetDlgItemText(hwnd, nCtrlID, buf);

				pData->bLocked = FALSE;

				SendMessage(GetParent(hwnd), PSM_CHANGED, (WPARAM)hwnd, 0);
				return 0;
			}
		}

		break;
	}

	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

LRESULT	CALLBACK ControlsPageProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	struct PageData *pData;

	if (pNextPageData) {
		pData = (struct PageData *)pNextPageData;
		pNextPageData = NULL;
		SetWindowLong(hwnd, DWL_USER, (LONG)pData);
	} else {
		pData = (struct PageData *)GetWindowLong(hwnd, DWL_USER);
	}

	switch (uMsg) {

	case WM_NOTIFY:

		{
			NMHDR	*pnmh = (NMHDR *)lParam;

			switch(pnmh->code) {

			case PSN_SETACTIVE:
				{
					int	nPos;
					char	szTmp[64];

					pData->bLocked = TRUE;

					nPos = (int)(100.0 * pData->fBlend1 + 0.5);
					if (nPos < 0)
						nPos = 0;
					if (nPos > 100)
						nPos = 100;

					SendDlgItemMessage(hwnd, IDC_BLEND1_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,100));
					SendDlgItemMessage(hwnd, IDC_BLEND1_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fBlend1);
					SetDlgItemText(hwnd, IDC_BLEND1_EDIT, szTmp);

					nPos = (int)(100.0 * pData->fBlend2 + 0.5);
					if (nPos < 0)
						nPos = 0;
					if (nPos > 100)
						nPos = 100;

					SendDlgItemMessage(hwnd, IDC_BLEND2_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,100));
					SendDlgItemMessage(hwnd, IDC_BLEND2_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fBlend2);
					SetDlgItemText(hwnd, IDC_BLEND2_EDIT, szTmp);

					nPos = (int)(100.0 * pData->fBlend3 + 0.5);
					if (nPos < 0)
						nPos = 0;
					if (nPos > 100)
						nPos = 100;

					SendDlgItemMessage(hwnd, IDC_BLEND3_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,100));
					SendDlgItemMessage(hwnd, IDC_BLEND3_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fBlend3);
					SetDlgItemText(hwnd, IDC_BLEND3_EDIT, szTmp);

					nPos = (int)(100.0 * pData->fBlend4 + 0.5);
					if (nPos < 0)
						nPos = 0;
					if (nPos > 100)
						nPos = 100;

					SendDlgItemMessage(hwnd, IDC_BLEND4_SLIDE,
						TBM_SETRANGE, 1, MAKELONG(0,100));
					SendDlgItemMessage(hwnd, IDC_BLEND4_SLIDE,
						TBM_SETPOS, 1, nPos);

					sprintf(szTmp, "%f", pData->fBlend4);
					SetDlgItemText(hwnd, IDC_BLEND4_EDIT, szTmp);

					pData->bLocked = FALSE;

					SetWindowLong(hwnd, DWL_MSGRESULT, 0);
					return TRUE;
				}
				break;
				
			case PSN_KILLACTIVE:
				{
					char	szTmp[64];
					HWND	hwndCtrl;
					float	fTmp;

					szTmp[64] = 0;

					hwndCtrl = GetDlgItem(hwnd, IDC_BLEND1_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1) {
numerr:					MessageBox(hwnd, "Please enter a number.", NULL, MB_OK);
						SetFocus(hwndCtrl);
						SetWindowLong(hwnd, DWL_MSGRESULT, TRUE);
						return TRUE;
					}
					if (fTmp < 0.0 || fTmp > 1.0) {
rangeerr:				MessageBox(hwnd, "Please enter a number between 0 and 1.", NULL, MB_OK);
						SetFocus(hwndCtrl);
						SetWindowLong(hwnd, DWL_MSGRESULT, TRUE);
						return TRUE;
					}

					pData->fBlend1 = fTmp;

					hwndCtrl = GetDlgItem(hwnd, IDC_BLEND2_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1)
						goto numerr;
					if (fTmp < 0.0 || fTmp > 1.0)
						goto rangeerr;

					pData->fBlend2 = fTmp;

					hwndCtrl = GetDlgItem(hwnd, IDC_BLEND3_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1)
						goto numerr;
					if (fTmp < 0.0 || fTmp > 1.0)
						goto rangeerr;

					pData->fBlend3 = fTmp;

					hwndCtrl = GetDlgItem(hwnd, IDC_BLEND4_EDIT);
					GetWindowText(hwndCtrl, szTmp, 63);
					if (sscanf(szTmp, "%f", &fTmp) != 1)
						goto numerr;
					if (fTmp < 0.0 || fTmp > 1.0)
						goto rangeerr;

					pData->fBlend4 = fTmp;

					SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
					return TRUE;
				}
				break;
			}
		}

		// else, "not handled"
		return FALSE;

	case WM_COMMAND:

		if (HIWORD(wParam) == EN_UPDATE) {
			if (!pData->bLocked) {
				switch(LOWORD(wParam)) {
				case IDC_BLEND1_EDIT:
				case IDC_BLEND2_EDIT:
				case IDC_BLEND3_EDIT:
				case IDC_BLEND4_EDIT:
					SendMessage(GetParent(hwnd), PSM_CHANGED, (WPARAM)hwnd, 0);
					return 0;
				}
			}
			break;
		}

		if (HIWORD(wParam) == EN_CHANGE) {
			if (!pData->bLocked) {

				int	nCtrlID2 = 0;

				switch(LOWORD(wParam)) {
				case IDC_BLEND1_EDIT:
					nCtrlID2 = IDC_BLEND1_SLIDE;
					break;
				case IDC_BLEND2_EDIT:
					nCtrlID2 = IDC_BLEND2_SLIDE;
					break;
				case IDC_BLEND3_EDIT:
					nCtrlID2 = IDC_BLEND3_SLIDE;
					break;
				case IDC_BLEND4_EDIT:
					nCtrlID2 = IDC_BLEND4_SLIDE;
					break;
				}

				if (nCtrlID2) {

					char	szTmp[64];
					float	fTmp;
					int	nPos = 0;

					szTmp[63] = 0;

					pData->bLocked = TRUE;

					GetDlgItemText(hwnd, LOWORD(wParam), szTmp, 63);
					if (sscanf(szTmp, " %f", &fTmp) == 1)
						nPos = (int)(100.0 * fTmp + 0.5);

					SendDlgItemMessage(hwnd, nCtrlID2, TBM_SETPOS, TRUE, nPos);

					pData->bLocked = FALSE;
				}
			}
		}

		// else default to DefWindowProc
		break;

	case WM_HSCROLL:
	case WM_VSCROLL:

		if (!pData->bLocked) {

			int	nCtrlID;
			HWND	hwndCtrl;

			pData->bLocked = TRUE;

			hwndCtrl = (HWND)lParam;		// handle of control
			nCtrlID = GetDlgCtrlID(hwndCtrl);

			switch(nCtrlID) {
			case IDC_BLEND1_SLIDE:
				nCtrlID = IDC_BLEND1_EDIT;
				break;
			case IDC_BLEND2_SLIDE:
				nCtrlID = IDC_BLEND2_EDIT;
				break;
			case IDC_BLEND3_SLIDE:
				nCtrlID = IDC_BLEND3_EDIT;
				break;
			case IDC_BLEND4_SLIDE:
				nCtrlID = IDC_BLEND4_EDIT;
				break;
			default:
				pData->bLocked = FALSE;
				break;
			}

			if (pData->bLocked) {
				int	nPos = SendMessage(hwndCtrl, TBM_GETPOS, 0, 0);
				char	buf[64];

				sprintf(buf, "%f", 0.01 * nPos);
				SetDlgItemText(hwnd, nCtrlID, buf);

				pData->bLocked = FALSE;

				SendMessage(GetParent(hwnd), PSM_CHANGED, (WPARAM)hwnd, 0);
				return 0;
			}
		}

		// else default to DefWindowProc
		break;
	}

	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////
// InfoPage property page WindowProc

LRESULT	CALLBACK InfoPageProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	struct PageData *pData;

	if (pNextPageData) {
		pData = (struct PageData *)pNextPageData;
		pNextPageData = NULL;
		SetWindowLong(hwnd, DWL_USER, (LONG)pData);
	} else {
		pData = (struct PageData *)GetWindowLong(hwnd, DWL_USER);
	}

	switch (uMsg) {

	case WM_INITDIALOG:

		{
			HGLOBAL	hInfoRsc;
			char	*pszInfo;
			HRSRC hRsc;

			hRsc = FindResource(hInst, MAKEINTRESOURCE(IDS_INFOTEXT), "TEXT");
			if (!hRsc)
			{
				MessageBox(GetParent(hwnd), "Error loading info text", NULL, MB_OK);
				EndDialog(hwnd, IDCANCEL);
				return TRUE;
			}

			hInfoRsc = LoadResource(hInst, hRsc);
			if (!hInfoRsc)
			{
				MessageBox(GetParent(hwnd), "Error loading info text", NULL, MB_OK);
				EndDialog(hwnd, IDCANCEL);
				return TRUE;
			}

			pszInfo = (char *)LockResource(hInfoRsc);
			if (!pszInfo)
			{
				FreeResource(hInfoRsc);
				MessageBox(GetParent(hwnd), "Error locking info text", NULL, MB_OK);
				EndDialog(hwnd, IDCANCEL);
				FreeResource(hInfoRsc);
				return TRUE;
			}

			SetDlgItemText(hwnd, IDC_EDIT, pszInfo);

			UnlockResource(hInfoRsc);
			FreeResource(hInfoRsc);

			return TRUE;
		}
		break;
	}

	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}
