VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "eCard"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'/File operating API's from the WIN32 API SDK
'
Private Declare Function ReadFile Lib "kernel32" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToRead As Long, lpNumberOfBytesRead As Long, ByVal lpOverlapped As Long) As Long
Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Private Declare Function WriteFile Lib "kernel32" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToWrite As Long, lpNumberOfBytesWritten As Long, ByVal lpOverlapped As Long) As Long
Private Declare Function CreateFile Lib "kernel32" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, ByVal lpSecurityAttributes As Long, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Private Declare Function FlushFileBuffers Lib "kernel32" (ByVal hFile As Long) As Long

'/File operating constants from the WIN32 API
'
Const GENERIC_READ = &H80000000
Const GENERIC_WRITE = &H40000000
Const FILE_ATTRIBUTE_NORMAL = &H80
Const OPEN_ALWAYS = 4
Const VFT_UNKNOWN = &H0&
Const VOS__WINDOWS32 = &H4&
Const VS_FF_PRIVATEBUILD = &H8&
Const VFT2_UNKNOWN = &H0&
Const VOS_DOS_WINDOWS32 = &H10004
Const VS_FF_DEBUG = &H1&
Const VOS_NT_WINDOWS32 = &H40004
Const VFT_APP = &H1&

'File structure types
'
Private Type VS_FIXEDFILEINFO '52 bytes
    dwSignature As Long
    dwStrucVersion As Long         '  e.g. 0x00000042 = "0.42"
    dwFileVersionMS As Long        '  e.g. 0x00030075 = "3.75"
    dwFileVersionLS As Long        '  e.g. 0x00000031 = "0.31"
    dwProductVersionMS As Long     '  e.g. 0x00030010 = "3.10"
    dwProductVersionLS As Long     '  e.g. 0x00000031 = "0.31"
    dwFileFlagsMask As Long        '  = 0x3F for version "0.42"
    dwFileFlags As Long            '  e.g. VFF_DEBUG Or VFF_PRERELEASE
    dwFileOS As Long               '  e.g. VOS_DOS_WINDOWS16
    dwFileType As Long             '  e.g. VFT_DRIVER
    dwFileSubtype As Long          '  e.g. VFT2_DRV_KEYBOARD
    dwFileDateMS As Long           '  e.g. 0
    dwFileDateLS As Long           '  e.g. 0
End Type
'
Dim VerHeader As VS_FIXEDFILEINFO
Dim gLastError As String
Public Sub Read(ByVal lpFileName As String)
'*****************************************'
'* This opens the file and reads the eCard
'* format. If the format is inccorect, the
'* eCardLastError property is set.
'*
'* lpFileName : is the name of file.
'*
'*****************************************'
Dim FileHandle As Long
Dim ReadLen    As Long
    
    ' Create new file, read write access, exclusive use,
    FileHandle = CreateFile(lpFileName, GENERIC_WRITE Or GENERIC_READ, _
                                0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0)
    If FileHandle = -1 Then
        gLastError = "Could not open specified file. Handle of file is, " & FileHandle
        FileHandle = 0
        Exit Sub
    End If
    Call ReadFile(FileHandle, VerHeader, Len(VerHeader), ReadLen, 0)
    If ReadLen <> Len(VerHeader) Then
        gLastError = "The version header did not match the byte map of the eCard."
        CloseHandle FileHandle
        FileHandle = 0
        Exit Sub
    End If
    Call ReadFile(FileHandle, ecBaseInfo, Len(ecBaseInfo), ReadLen, 0)
    If ReadLen <> Len(ecBaseInfo) Then
        gLastError = "The eCard base structure did not match the byte map of the eCard."
        CloseHandle FileHandle
        FileHandle = 0
        Exit Sub
    End If
    CloseHandle FileHandle
    FileHandle = 0



End Sub

Public Sub Create(ByVal lpFileName As String)
'*****************************************'
'* This Creates the file and stores the info
'* in the eCard format. If the creation fails
'* the eCardLastError property is set.
'*
'* lpFileName : is the name of file.
'*
'*****************************************'
Dim FileHandle As Long
Dim Written    As Long

    'sets the header of the file. (version)
    With VerHeader
        .dwSignature = &H48 & &H53 & &H45 & &H43 '=string:ASCII"HSEC"
        .dwStrucVersion = &H29
        .dwFileVersionMS = &H1
        .dwFileVersionLS = &H1
        .dwProductVersionMS = &H6E
        .dwProductVersionLS = &HB
        .dwFileFlagsMask = VS_FF_DEBUG
        .dwFileFlags = VS_FF_DEBUG
        .dwFileOS = VOS_NT_WINDOWS32
        .dwFileType = VFT_APP
        .dwFileSubtype = VFT2_UNKNOWN
        .dwFileDateLS = 0
        .dwFileDateMS = 0
    End With



    ' Create new file, read write access, exclusive use,
    FileHandle = CreateFile(lpFileName, GENERIC_READ Or GENERIC_WRITE, _
                                0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0)
    If FileHandle = -1 Then
        gLastError = "The eCard file image could not be created. Handle of failed file is " & FileHandle
        FileHandle = 0
        Exit Sub
    End If
    ' Write the initial file info
    Call WriteFile(FileHandle, VerHeader, LenB(VerHeader), Written, 0)
    If Written <> LenB(VerHeader) Then
        gLastError = "The version header did not match the byte map of the eCard. Please check version structure type."
        CloseHandle FileHandle
        FileHandle = 0
        Exit Sub
    End If
    Call WriteFile(FileHandle, ecBaseInfo, LenB(ecBaseInfo), Written, 0)
    If Written <> LenB(ecBaseInfo) Then
        gLastError = "The eCard information base did not match the byte map of the eCard base type."
        CloseHandle FileHandle
        FileHandle = 0
        Exit Sub
    End If
    Call FlushFileBuffers(FileHandle)
    ' Now we need a mapping
    CloseHandle FileHandle
    FileHandle = 0
End Sub

Public Property Get eCardLastError() As String
    eCardLastError = gLastError
End Property

Public Property Let eCardLastError(ByVal vNewValue As String)
    gLastError = vNewValue
End Property
