#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
/* #include <dos.h> */

#pragma align 1
#define A1 __attribute__ ((aligned(1)))
#define P1 __attribute__ ((aligned(1),packed))
#define O_BINARY 0 /* not used on Linux */
#define O_DENYWRITE O_EXCL /* maybe? */

#define OPT_QUICK 1
#define OPT_VERB  2
#define ER_FATAL -1	/* fatal (eg. malloc)*/
#define ER_DHDRD 64	/* data hdr read err */
#define ER_UNKDT 64	/* unknown data type */
#define ER_DATRD 32	/* data rec read err */
#define ER_DFILSH 32	/* data file short   */
#define ER_KEYIB 16	/* key info struct.b */
#define ER_KEYSB 16	/* key structure bad */
#define ER_KEYRD 8	/* key file read err */
#define ER_KEYLV 4	/* last key val. bad */
#define ER_KEYNM 2	/* key/data mismatch */
#define ER_KEYOP 1	/* key file open err */
#define CHKCNT 2	/* # 32-bit checksums per key */
#define CRC_0 0x010208f1LU /* 0x1010208f1LU */
#define CRC_1 0x02084019LU /* 0x102084019LU */
#define KBS 512		/* key file block size */
#define OPEN_RDONLY O_BINARY|O_RDONLY
#define OPEN_RDEXCL O_BINARY|O_RDONLY|O_DENYWRITE
#define S_NORM S_IFREG|S_IREAD|S_IWRITE
#define OPEN_CREATE O_RDWR|O_BINARY|O_CREAT|O_TRUNC|O_DENYALL,S_NORM
#define DEBUG 0
#define KEYINFO 0
/*
Options.CTL structure:
offset	value
000-003	86 A7 00 00
004-103	collating table: use character value as index in the table to get
			 value used to build key (in key and index files)
104-136	uppercase alpha in national order
137-169	lowercase alpha in national order
16A-199	month names abbreviations (each char[4] = 3-char + 0-terminator)
19A-235	month names (each char[13] = 12-char + 0-terminator)
236-552	various strings to be used in error displays
*/

typedef unsigned char byte;
typedef unsigned short word;
/* typedef unsigned long ulong; */

/* Data file header structure: */
struct cl_file_header {
/*00*/	word	filesig;	/* file signature: 0x3343 */
/*02*/	word	sfatr;		/* file attribute and status */
	/* bit	0:locked, 1:owned, 2:encrypted, 3:memo exists, 4:compressed,
		5:reclaim deleted record, 6:read only, 7:may be created */
/*04*/	byte	numbkeys;	/* number of keys in file */
/*05*/	ulong	numrecs;	/* number of records in file */
/*09*/	ulong	numdels;	/* number of deleted records */
/*0d*/	word	numflds;	/* number of fields */
/*0f*/	word	numpics;	/* number of pictures */
/*11*/	word	nummars;	/* number of array descriptors */
/*13*/	word	reclen ;	/* record length (including record header) */
/*15*/	ulong	offset ;	/* start of data area */
/*19*/	ulong	logoef ;	/* logical end of file */
/*1d*/	ulong	logbof ;	/* logical beginning of file */
/*21*/	ulong	freerec;	/* first usable deleted record */
/*25*/	byte	recname[12];	/* record name w/o prefix ("RECORD", 0 fill) */
/*31*/	byte	memnam[12];	/* memo name without prefix */
/*3d*/	byte	filpre[3];	/* file name prefix */
/*40*/	byte	recpre[3];	/* record name prefix */
/*43*/	word	memolen;	/* size of memo */
/*45*/	word	memowid;	/* column width of memo */
/*47*/	ulong	reserved1;	/* reserved (really always was 0) */
/*4b*/	ulong	chgtime;	/* time of last change (sec/100 s/ midnight) */
/*4f*/	ulong	chgdate;	/* date of last change (days s/ 28-Dec-1800) */
/*53*/	word	reserved2;	/* reserved */
				/* (sum of all preceding bytes in encrypted
				    file, was always 0 in unencrypted) */
} P1;

struct field_descr {
	byte	fldtype;	/* type of field */
	/*	1:long, 2:real, 3:string, 4:string with picture token,
		5:byte, 6:short, 7:group, 8:decimal	*/
	char	fldname[16];	/* name of field (blank pad) */
	word	foffset;	/* offset into record (from 0) */
	word	length;		/* length of field */
	byte	decsig;		/* significance for decimals */
	byte	decdec;		/* number of decimal places */
	word	arrnum;		/* array number */
	word	picnum;		/* picture number */
} P1;

struct key_sect_info {
	byte	numcomps;	/* number of components for key */
	char	keynams[16];	/* name of this key */
	byte	comptype;	/* type of composite */
		/* bit	7:	loksw(1:key file locked, 0:not),
			6:	optsw(1:don't, 0:exclude nulls),
			5:	uprsw(1:uppercase, 0:case sensitive),
			4:	dupsw(1:duplicate keys allowed, 0:unique)
			3-0:	ftyp=0:key,1:index(dupsw never set) */
	byte	complen;	/* length of composite */
} P1;
struct key_part_info {
	byte	fldtype;	/* type of field (same as in f.d.) */
	word	fldnum;		/* field number (first is 1) */
	word	elmoff;		/* record offset of this element */
	byte	elmlen;		/* length of element */
} P1;

struct data_header {
	byte	rhd;		/* record header type and status */
	/* bits	0:new, 1:old, 2:revised, 4:deleted, 6:held */
	ulong	rptr;		/* pointer for next deleted record
				   or memo if active */
} P1;

struct key_header {	/* key file header record */
/*00*/	ulong	root;		/* number of root node */
/*04*/	ulong	numkent;	/* number of key entries */
/*08*/	ulong	numnode;	/* number of nodes for this index */
				/* (includes non-referenced nodes)*/
/*0c*/	ulong	lastnod;	/* node number of last node */
/*10*/	ulong	keyeof;		/* record # of end of file */
/*14*/	ulong	keybof;		/* record # of beginning of file */
/*18*/	ulong	unused;		/* first unused node of file (always 0) */
/*1c*/	byte	keytyp;		/* type of key */
	/* bit 7:loksw, 6:optsw, 5:uprsw, 4:dupsw, 3-0:ftyp=0:key,1:index */
/*1d*/	byte	keynode;	/* # of keys per node */
/*1e*/	byte	numcmps;	/* # of components of key */
/*1f*/	word	keylen;		/* total length of key entry */
/*21*/	word	numlvls;	/* number of levels */
/*23*/	char	cvoid[1/*477*/];/* reserved space (truncated now) */
} P1;	/* root node is at offset root*KBS */
struct key_node_hdr {
	byte	keycnt;		/* number of keys in this nodes */
	ulong	flink;		/* forward node pointer */
	ulong	blink;		/* backwards node printer */
	ulong	ulink;		/* upwards node pointer */     } P1;
struct key_entry {
	ulong	relrec;		/* record number/node number */
	byte	key[2];		/* key value (key size - size of long)*/
} P1;

char collate1[256],collate2[256]; /* 1 maps to uppercase, 2 uses 2 cases */
char monthnam[48]=
	{"Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec"};
ulong crctab[CHKCNT][256]; byte Options=0,ErrFlag=0;

void setfnext(char *fns,const char *ext) {
	int lng,dot;
	for(dot=lng=strlen(fns); lng-->0; ) {
		switch(fns[lng]) {
			case '.': dot=lng;
			case '/':; case '\\':; case ':': break;
			default: continue;
		} break;
	}
	fns[dot++]='.'; strcpy(fns+dot,ext);
}

int time_to_hmsf(ulong clt,char *hour,char *min,char *sec,char *frac) {
	if(--clt>=8640000LU) return(-1);
	*frac=(byte)(clt%100U); clt/=100U; *sec=(byte)(clt%60U); clt/=60U;
	*min=(byte)(clt%60U); clt/=60U; *hour=(byte)(clt); return(0);
}

int date_to_ymd(ulong cld,int *year,char *mon,char *day) {
	int y,m,d; char ndm[12]={31,28,31,30,31,30,31,31,30,31,30,31};
	if(cld<=3 || cld>109211LU) return(-1); cld+=(cld>36527LU)-4;
	y=(word)(1801U+(4*(cld/1461U))); if((d=(word)(cld%1461U))!=1460U)
		{ y+=d/365; d%=365; } else { y+=3; d=365; }
	if(y<100) y+=1900; *year=y; ndm[1]=28+(y%4==0 && y!=1900);
	for(m=0; m<12 && d>=ndm[m]; d-=ndm[m++]); *mon=m+1; *day=d+1;
	return(0);
}

int read_options_ctl(void) {
	char upperalpha[51],loweralpha[51]; int idx;
	FILE *ocf; static char ocfns[]="options.ctl";
	if((ocf=fopen(ocfns,"rb"))==NULL) goto ferr;
	if(fread(upperalpha,4,1,ocf)!=1) goto ferr;
	if(*(long*)upperalpha!=0x0000A786L)
		{ fprintf(stderr,"%s: signature bad\n",ocfns); goto errx; }
	if(fread(collate2,sizeof(collate2),1,ocf)!=1) goto ferr;
	if(fread(upperalpha,sizeof(upperalpha),1,ocf)!=1) goto ferr;
	if(fread(loweralpha,sizeof(loweralpha),1,ocf)!=1) goto ferr;
	for(idx=0; idx<sizeof(collate1); idx++) collate1[idx]=collate2[idx];
	for(idx=0; idx<sizeof(loweralpha); idx++)
		if(upperalpha[idx]==0 || loweralpha[idx]==0) break;
		else	collate1[0xff&loweralpha[idx]]=
			collate2[0xff&upperalpha[idx]];
	if(fread(upperalpha,sizeof(monthnam),1,ocf)!=1) goto ferr;
	for(idx=0; idx<sizeof(monthnam); idx++) monthnam[idx]=upperalpha[idx];
	fclose(ocf); return(0);
ferr:	perror(ocfns);
errx:	if(ocf!=NULL) { fclose(ocf); ErrFlag=ER_FATAL; }
	for(idx=0; idx<sizeof(collate1); idx++)
		collate1[idx]=collate2[idx]=idx;
	for(idx='a'; idx<='z'; idx++) collate1[idx]^=' '; return(-1);
}

/*
void show_options(void) {
	for(idx=0; idx<sizeof(collate1); idx++)
		printf("%02x%c",0xff&collate1[idx],(idx&0xf)==0xf?'\n':' ');
	printf("\n");
	for(idx=0; idx<sizeof(collate2); idx++)
		printf("%02x%c",0xff&collate2[idx],(idx&0xf)==0xf?'\n':' ');
	printf("\n");
} */

struct key_main_info {
	byte	ncomp,ctype;	/* # components, composite type	*/
	word	clngt;		/* composite size in bytes	*/
	struct	key_supl_info	*ksinf;	/* supplemental info	*/
	ulong	encnt,		/* entry count in key file	*/
		kchk[CHKCNT];	/* checksum of composite	*/
} P1 *kmip;
struct key_supl_info {
	word	fofst;		/* component offset in record	*/
	byte	ftype,fsize;	/* type and size of component	*/
	void	*pbuf;		/* buffer for key part		*/
} P1;

FILE *cdf=NULL; struct cl_file_header cfh;
struct key_sect_info ksi;
struct key_part_info kpi;
struct data_header *rbp; char *rdp;

int make_key_part(struct key_main_info *kmi,struct key_supl_info *ksi) {
	int i,l,v; char *s,*d,*t; i=l=ksi->fsize;
	v=kmi->ctype&0x40; /* 0 if need exclude nulls */
	s=rdp+ksi->fofst; d=(char*)(ksi->pbuf);
	switch(ksi->ftype) {
	case 1	: /* long -	swap and toggle highest bit */
		*d++=*(s+=3)^0x80; while(i-->1) *d++=*--s; goto chknn;
	case 2	: /* real -	if sign bit set clear it else negate
				the byte; negate all other bytes and
				reverse their order */
		s+=i-1; *d++=*s<0?~*s:*s^0x80;
		while(i-->1) *d++=~*--s; goto chknn;
	case 3	: /* string -	use collating table */
	case 4	: /* picture -	unmodified? or as string? */
		t=(kmi->ctype & 0x20)?collate1:collate2;
		while(i-->0) *d++=t[(byte)(*s++)]; goto chkbs;
	case 5	: /* byte -	unmodified */
		if(!v) v = *s!=0; *d=*s; goto chknn;
	case 6	: /* short -	swap and toggle highest bit */
		*d++=*++s^0x80; *d=*--s; goto chknn;
	case 7	: /* group -	unmodified? or as string? */
	/*	while(i-->0) *d++=*s++; goto chkbs;	*/
		t=(kmi->ctype & 0x20)?collate1:collate2;
		while(i-->0) *d++=t[(byte)(*s++)]; /* goto chkbs; */
		if(v) return(1); for(i=l; i-->0; )
			if((*--s|' ')!=' ') return(1); return(0);
	case 8	: /* decimal -	if highest order byte bit 7 set
				negate all else set the bit */
		if(*(t=s)<0) while(i-->0) *d++=~*t++;
		else { *d=*t^0x80; while(i-->1) *++d=*++t; }
		goto chknn;
	default	: /* undefined */ ErrFlag|=ER_UNKDT; return(-1);
	}
chknn:	if(v) return(1); for(i=l; i-->0; ) if(*s++) return(1); return(0);
chkbs:	if(v) return(1); for(i=l; i-->0; )if(*--s!=' ')return(1); return(0);
}

void checksum_key(struct key_main_info *kmi,ulong pos) {
	int len0,len,ick; byte *ckp,*ckp0; ulong u,*ctab;
	len0=kmi->clngt; ckp0=(byte*)(kmi->ksinf+kmi->ncomp);
#if DEBUG
	printf("%08x",pos); for(len=0; len<len0; )
		printf(" %02x",ckp0[len++]); printf("\n");
#endif
	for(kmi->encnt++, ick=0; ick<CHKCNT; ick++) {
		ctab=crctab[ick];
		for(u=pos, len=4; len-->0; )
			u=(u>>8)^ctab[*(byte*)&u];
		for(ckp=ckp0, len=len0; len-->0; )
			u=(u>>8)^ctab[*(byte*)&u ^ *ckp++];
		kmi->kchk[ick]+=u;
}	}

void getoptions(char *ostr) { /* note 1st char is '-' */
	for(;;) switch(*++ostr) {
		case 0  :	return;
		case 'q':	Options^=OPT_QUICK; break;
		case 'v':	Options^=OPT_VERB; break;
		default:	fprintf(stderr,"%s: unknown option\n",ostr);
				return;
}	}

char *showfileinfo(char *fn) {
	int dy; char dm,dd,th,tm,ts,tf;
	if(date_to_ymd(cfh.chgdate,&dy,&dm,&dd)<0)
		return("%s: Invalid change date value\n");
	if(time_to_hmsf(cfh.chgtime,&th,&tm,&ts,&tf)<0)
		return("%s: Invalid change time value\n");
	if(Options & OPT_VERB)
		printf("%s, changed: %02u-%-3s-%04u %02u:%02u:%02u.%02u\n",
			fn,dd,monthnam+((dm-1)<<2),dy,th,tm,ts,tf);
	return(NULL);
}

struct key_header kfhdr; int kfh; long kfp; struct key_main_info *akmip;
struct key_node_info {
	ulong			point;	/* pointer to this node	*/
	struct	key_node_hdr	h;	/* header */
	/*	byte keycnt;	ulong flink,blink,ulink;	*/
	byte	e[KBS-sizeof(struct key_node_hdr)]; /* entries	*/
	/* struct key_entry { ulong relrec; byte key[]; }	*/
			/* key[]=key value[keylen-sizeof(long)]	*/
} *knip;

void cks_key_entry(byte *kval) {
	int len,ick; byte *ckp; ulong u,*ctab;
#if DEBUG
	printf("%08x",*(long*)kval); for(len=4; len<kfhdr.keylen; )
		printf(" %02x",kval[len++]); printf("\n");
#endif
	for(akmip->encnt--, ick=0; ick<CHKCNT; ick++) {
		ctab=crctab[ick]; u=0;
		for(ckp=kval, len=kfhdr.keylen; len-->0; )
			u=(u>>8)^ctab[*(byte*)&u ^ *ckp++];
		akmip->kchk[ick]-=u;
}	}

int read_key_block(word lev,ulong num) {
	if(num!=kfp) lseek(kfh,KBS*num,SEEK_SET);
	if(read(kfh,(void*)&(knip[lev].h),KBS)!=KBS)
		{ kfp=-1; ErrFlag|=ER_KEYRD; return(-1); }
	knip[lev].point=num; kfp=num+1; return(0);
}

byte *adv_key_entry(word lev) {
	static ulong tlink,*parnt; struct key_node_info *kniplv=knip+lev;
	if(++*(word*)&(kniplv->h.blink)==kniplv->h.keycnt) {
		if(lev==0 || kniplv->h.flink==0) return(NULL);
		tlink=kniplv->point;
		if(read_key_block(lev,kniplv->h.flink)<0) return(NULL);
		if(kniplv->h.blink!=tlink) return(NULL); kniplv->h.blink=0;
		if((parnt=(ulong*)adv_key_entry(lev-1))==NULL
			|| kniplv->h.ulink!=(kniplv-1)->point
			|| kniplv->point!=*parnt) return(NULL);
		if(memcmp((char*)(parnt+1),kniplv->e+(kniplv->h.keycnt-1)
			*(akmip->clngt+4)+4,akmip->clngt)!=0) return(NULL);
	}
	return(kniplv->e+kfhdr.keylen*(*(word*)&(kniplv->h.blink)));
}

int get_data_record(ulong dri) {
	int i,r;
	fseek(cdf,cfh.offset+(dri-1)*cfh.reclen,SEEK_SET);
	if(fread(rbp,cfh.reclen,1,cdf)!=1) { ErrFlag|=ER_DATRD; return -1; }
	if((rbp->rhd & 0x10)!=0) return -1; /* deleted data read */
	for(r=i=0; i<akmip->ncomp; i++)
		r|=make_key_part(akmip,akmip->ksinf+i);
	return(r);
}

int kopen(char *dfn,int kidx) {
	static char lkens[][18]={"last node empty",
		"data unaccessible","bad key value"};
	int tmp; ulong kbn,upl; char key_ext[4]; kidx++; kfp=-1;
	if((tmp=(kidx)/36)>9) tmp+='a'-'9'-1; key_ext[1]=tmp+'0';
	if((tmp=(kidx)%36)>9) tmp+='a'-'9'-1; key_ext[2]=tmp+'0';
	key_ext[0]='k'; key_ext[3]=0; setfnext(dfn,key_ext);
	if((kfh=open(dfn,OPEN_RDEXCL))==-1) { ErrFlag|=ER_KEYOP; goto maerr; }
	if(read(kfh,&kfhdr,sizeof(kfhdr))!=sizeof(kfhdr))
		{ ErrFlag|=ER_KEYRD; goto maerr; }
	if((int)(knip=sbrk(sizeof(*knip)*kfhdr.numlvls))==-1)
		{ ErrFlag|=ER_FATAL; goto maerr; }
	if(kfhdr.numkent /* was: numlvls */ >0) {
		if(read_key_block(0,kfhdr.lastnod)==-1) goto rderr;
		if((tmp=knip->h.keycnt)==0) { tmp=0; goto lkerr; }
		tmp=(tmp-1)*kfhdr.keylen; kbn=*(ulong*)(knip->e+tmp);
		tmp+=4; if(get_data_record(kbn)<=0) { tmp=1; goto lkerr; }
		if(memcmp(knip->e+tmp,akmip->ksinf+akmip->ncomp,
			akmip->clngt)!=0) { tmp=2; goto lkerr; }
	}
	for(kbn=kfhdr.root,upl=tmp=0; tmp<kfhdr.numlvls; tmp++) {
	/*	geninterrupt(3);	*/
		if(read_key_block(tmp,kbn)==-1) goto rderr;
		if(knip[tmp].h.blink!=0 || knip[tmp].h.ulink!=upl)
			goto kierr; if(tmp==0 && kfhdr.numkent==0) {
			if(knip[tmp].h.flink!=0 || knip[tmp].h.keycnt!=0
			|| kfhdr.numlvls>1) goto kierr; break;
		}
		upl=kbn; if(knip[tmp].h.keycnt==0
			|| (kbn=*(ulong*)knip[tmp].e)==0) goto kierr;
		if(tmp>0) if(*(ulong*)(knip[tmp-1].e)!=upl ||
				memcmp(knip[tmp-1].e+4,knip[tmp].e
					+(knip[tmp].h.keycnt-1)
					*(akmip->clngt+4)+4,
					akmip->clngt)!=0) goto kierr;
	}
	return(kfh);
maerr:	perror(dfn); knip=sbrk(0); goto errex; /* ErrFlag set at goto maerr */
rderr:	perror(dfn); goto errex; /* ErrFlag set in read_key_block() */
kierr:	fprintf(stderr,"%s: key info error:\n"
		"c=%04x, o=%08x, b=%08x, f=%08x, u=%08x, n=%08x\n",dfn,
		knip[tmp].h.keycnt,upl,knip[tmp].h.blink,knip[tmp].h.flink,
		knip[tmp].h.ulink,kbn); ErrFlag|=ER_KEYIB; goto errex;
lkerr:	fprintf(stderr,"%s: last key in error - %s\n",dfn,lkens[tmp]);
	ErrFlag|=ER_KEYLV;
errex:	if(kfh!=-1) close(kfh); brk((void*)knip); return(-1);
}

char *readkeyinfo(void) {
	int kix,kci; byte *kval;
	/* seek start of key info */
	if(fseek(cdf,cfh.numflds*sizeof(struct field_descr),SEEK_CUR)
		==-1) goto ioerr;
	/* allocate memory for key info and record buffer */
	/*  void *sbrk(int incr); int brk(void *endds);  */
	if((int)(kmip=sbrk(cfh.numbkeys*sizeof(*kmip)+cfh.reclen))
		==-1) goto maerr;
	memset((char*)kmip,0,cfh.numbkeys*sizeof(*kmip)+cfh.reclen);
	rdp=(char*)((rbp=(struct data_header*)(kmip+cfh.numbkeys))+1);
	/* now read the key info - for every key: */
	for(akmip=kmip,kix=0; kix<cfh.numbkeys; kix++,akmip++) {
		/* read the key main info */
		if(fread((char*)&ksi,sizeof(ksi),1,cdf)!=1) goto ioerr;
		akmip->ctype=ksi.comptype; akmip->clngt=ksi.complen;
	/*	for(idx=0; idx<CHKCNT; idx++) akmip->kchk[idx]=0;	*/
		/* allocate memory for supplemental info */
		if((int)(akmip->ksinf=sbrk((akmip->ncomp=ksi.numcomps)
			*sizeof(struct key_supl_info)+ksi.complen))==-1)
			goto maerr;
		/* read component info - for every: */
		kval=(byte*)(akmip->ksinf+ksi.numcomps);
		for(kci=0; kci<ksi.numcomps; kci++) {
			/* read the info */
			if(fread((char*)&kpi,sizeof(kpi),1,cdf)!=1)
				goto ioerr;
			akmip->ksinf[kci].fofst=kpi.elmoff;
			akmip->ksinf[kci].ftype=kpi.fldtype;
			akmip->ksinf[kci].fsize=kpi.elmlen;
			akmip->ksinf[kci].pbuf=kval; kval+=kpi.elmlen;
		}
#if KEYINFO
		printf(	"%s %-16.16s %2u components %3u bytes %s%s%s%s\n",
			(ksi.comptype&0xf)?"index":"key",
			ksi.keynams,ksi.numcomps,ksi.complen,
			(ksi.comptype&0x10)?" Dup":"",
			(ksi.comptype&0x20)?" Upr":"",
			(ksi.comptype&0x40)?" Opt":"",
			(ksi.comptype&0x80)?" Lock":"");
#endif
	}
	return(NULL);
maerr:	ErrFlag|=ER_FATAL; return("memory exhausted during processing\n");
ioerr:	ErrFlag|=ER_DHDRD; return("");
}

char *processfile(char *fn) {
	int kix,kci,idx; ulong dri,lt; void *sbrk1; byte *kval;
	/* open file and read Clarion file header */
	if((cdf=fopen(fn,"rb"))==NULL) goto ioerr;
	if(fread((char*)&cfh,sizeof(cfh),1,cdf)!=1) goto ioerr;
	/* show file info: name, date, time */
	if((cfh.sfatr&4)!=0) { fclose(cdf); return NULL; }
	if((char*)(lt=(ulong)showfileinfo(fn))!=NULL) {
/*		printf("***"); fflush(stdout);
		printf("file %s\nsig=%04x, sfattr=%04x, keys=%u, ",
			fn, cfh.filesig, cfh.sfatr, cfh.numbkeys);
		fflush(stdout);
		printf("recs=%lx, dels=%lx, flds=%x, pics=%x, arrs=%x\n",
			cfh.numrecs, cfh.numdels,
			cfh.numflds, cfh.numpics, cfh.nummars);
		fflush(stdout);
		printf("reclen=%x, offset=%lx, logeof=%lx, logbof=%lx, "
			"freechn=%lx\n",
			cfh.reclen, cfh.offset, cfh.logoef, cfh.logbof,
			cfh.freerec);
		fflush(stdout); */
		return((char*)lt);
	}
	/* read key info */
	if((char*)(lt=(ulong)readkeyinfo())!=NULL)
		{ perror(fn); return((char*)lt); }
	/* verify file size if OK */
	lt=cfh.reclen*cfh.numrecs+cfh.offset; fseek(cdf,0,SEEK_END);
	if((dri=ftell(cdf))<lt)
		{ ErrFlag|=ER_DFILSH; return("%s: file too short\n"); }
	if(dri>lt) printf("Warning: garbage on end of file.\n");
	if((Options&OPT_QUICK)==0) /* now process all data records */
	for(fseek(cdf,cfh.offset,SEEK_SET),dri=0; dri++<cfh.numrecs; ) {
		if(fread(rbp,cfh.reclen,1,cdf)!=1) goto ioerr;
		if(rbp->rhd & 0x10) continue; /* this record is deleted */
		for(akmip=kmip,kix=0; kix<cfh.numbkeys; kix++,akmip++) {
			for(idx=kci=0; kci<akmip->ncomp; kci++)
				idx|=make_key_part(akmip,akmip->ksinf+kci);
			if(idx<0) return("%s: unknown data type\n");
			if(idx) checksum_key(akmip,dri);
	}	}
	sbrk1=sbrk(0);
	for(akmip=kmip,kix=0; kix<cfh.numbkeys; kix++,akmip++) {
		/* putch('.'); */ if(akmip->ctype&0x0f) continue;
		if(kopen(fn,kix)==-1) continue;
		if((Options&OPT_QUICK)==0 && kfhdr.numlvls>0) {
			if(knip[kfhdr.numlvls-1].h.keycnt!=0) {
				cks_key_entry(knip[kfhdr.numlvls-1].e);
				while((kval=adv_key_entry(kfhdr.numlvls-1))
					!=NULL) cks_key_entry(kval);
			}
			if(knip[kfhdr.numlvls-1].point!=kfhdr.lastnod
			|| *(word*)&(knip[kfhdr.numlvls-1].h.blink)
			!= knip[kfhdr.numlvls-1].h.keycnt) {
				ErrFlag|=ER_KEYSB; fprintf(stderr,
					"%s: key file structure bad\n",fn);
		}	}
		brk((void*)knip); close(kfh);
		kci=0; if((Options&OPT_QUICK)==0)
			for(kci=akmip->encnt!=0, idx=0; idx<CHKCNT; idx++)
				kci |= akmip->kchk[idx]!=0;
		if(kci) { ErrFlag|=ER_KEYNM;
			fprintf(stderr,"%s: bad key file\r\n",fn);
	}	}
	if(sbrk(0)==sbrk1) brk(kmip);
	else fprintf(stderr,"%s: fail to deallocate memory\n",fn);
	fclose(cdf); /* printf("kmip=%p\n",kmip); */ return(NULL);
ioerr:	perror(fn); return("");
}

void init_crctab(ulong *ctp,ulong pol) {
	ulong rp; int bx,c;
	for(rp=bx=0; bx<32; bx++) { rp=(rp>>1)|(pol&0x80000000UL);pol<<=1; }
	for(c=0; c<256; ctp[c++]=pol)
		for(pol=c,bx=0; bx<8; bx++)
			pol=(pol>>1)^((-(1&*(byte*)&pol))&rp);
}

char *Usage="Usage: %s [-qv] clarion-data-file-name(s)\n";

main(int acnt,char *avec[]) {
	int aix; char *em,*fn;
	/* initialize CRC tables */
	init_crctab(crctab[0],CRC_0); init_crctab(crctab[1],CRC_1);
	/* read info from Options.CTL file */
	if(read_options_ctl()<0) /* return(-1) */; /* show_options(); */
	/* check if have any args, error if none */
	if(acnt<=1) { fn=avec[0]; em=Usage; goto errex; }
	/* process options/files specified by args */
	for(aix=1; aix<acnt; )
		/* get arg, check if it is option */
		if(*(fn=avec[aix++])=='-') getoptions(fn);
		/* otherwise assume it is file name */
		else if((em=processfile(fn))!=NULL) goto errex;
	return(ErrFlag);
errex:	if(em!=NULL) fprintf(stderr,em,fn);
	if(cdf!=NULL) fclose(cdf); return(ErrFlag);
}/*
Info needed for key processing:
- for entire file:
  - how many keys
  - record size
  - # of records
  - buffer for record
- for every key:
  - 0B	which key/index, key or index (key/index file name)
	(note:	1. common numbering for keys and indices,
		2. not necessary in key info structore)
  - 1B	number of components (or terminator in c. info)
  - 1B	composite type (flags which affect processing: uprsw, optsw)
  - 1W	length of composite
  - 1P	pointer to other info (key value buffer, component info)
  - ?L	checksum (one or more longwords)
- for every component:
  - field type (B), offset (W), size (B)
*/
#if 0
char inpname[128],outname[128],key_ext[4]="k";
union { byte b[0x200]; indx_hdr_s h; indx_dir_s d; } key_buf;
int read_key_block(int inpkh,long block) {
	if(lseek(inpkh,block<<9,SEEK_SET)==-1L) return(-1);
	return(-(read(inpkh,&key_buf,sizeof(key_buf))!=sizeof(key_buf)));
}

void farmcpy(void far *d,void far *s,size_t l) {
	movedata(((word*)&s)[1],*(word*)&s,((word*)&d)[1],*(word*)&d,l);
}

int process_key_file(int kidx) {
	long nextb,first; word kptr; buffer_descr far *bfdp,far *bffp;
	int outi,kiib,kofs,sflg,tmp;
#ifdef KEEPFAL
	word firps,lirps; byte afirs,alirs;
#endif
	/* some initialization */
	if((tmp=(kidx+1)/36)>9) tmp+='a'-'9'-1; key_ext[1]=tmp+'0';
	if((tmp=(kidx+1)%36)>9) tmp+='a'-'9'-1; key_ext[2]=tmp+'0';
	setfnext(inpname,key_ext); printf("Input=\"%s\"\n",inpname);
	outi=-1; if((inpkh=open(inpname,OPEN_RDEXCL))==-1) goto ioerr;
	RDKEYBLK(0); ksiz=key_buf.h.ksiz; kcpb=key_buf.h.kcpb;
...
}

typedef unsigned char byte,indx_block[0x200];

#endif
