/*
 * Sample Middlegame KeySource file.
 *
 * Andy Duplain, Nov 1993.
 */

echo +----------------------------------+
echo | Sample Middlegame KeySource file |
echo +----------------------------------+

info_tests_only false
subkey_related true

key "Various sacrifices" {
	/*
	 * the sacrifices are defined as a piece moving to a particular
	 * square or capturing a Pawn on a particular square, which is
	 * then immediately captured by the opponent, but the opponents
	 * capturing piece is *not* then re-captured in exchange.
	 */
	key "White sacrifices a piece on e7" {
		key "W%n sac on e7" {
			(WhN-e7 | WhNxPe7), xe7, !xe7
		}
		key "W%b sac on e7" {
			(WhB-e7 | WhBxPe7), xe7, !xe7
		}
		key "W%r sac on e7" {
			(WhR-e7 | WhRxPe7), xe7, !xe7
		}
	}
	key "White sacrifices a piece on f7" {
		key "W%n sac on f7" {
			(WhN-f7 | WhNxPf7), xf7, !xf7
		}
		key "W%b sac on f7" {
			(WhB-f7 | WhBxPf7), xf7, !xf7
		}
		key "W%r sac on f7" {
			(WhR-f7 | WhRxPf7), xf7, !xf7
		}
	}
	key "White sacrifices a piece on g7" {
		key "W%n sac on g7" {
			(WhR-g7 | WhNxPg7), xg7, !xg7
		}
		key "W%b sac on g7" {
			(WhB-g7 | WhBxPg7), xg7, !xg7
		}
		key "W%r sac on g7" {
			(WhR-g7 | WhRxPg7), xg7, !xg7
		}
	}
	key "White sacrifices a piece on h7" {
		key "W%n sac on h7" {
			(WhN-h7 | WhNxPh7), xh7, !xh7
		}
		key "W%b sac on h7" {
			(WhB-h7 | WhBxPh7), xh7, !xh7
		}
		key "W%r sac on h7" {
			(WhR-h7 | WhRxPh7), xh7, !xh7
		}
	}
	key "White sacrifices a piece on e6" {
		key "W%n sac on e6" {
			(WhN-e6 | WhNxPe6), xe6, !xe6
		}
		key "W%b sac on e6" {
			(WhB-e6 | WhBxPe6), xe6, !xe6
		}
		key "W%r sac on e6" {
			(WhR-e6 | WhRxPe6), xe6, !xe6
		}
	}
	key "Black sacrifices a piece on e2" {
		key "B%n sac on e2" {
			(BlN-e2 | BlNxPe2), xe2, !xe2
		}
		key "B%b sac on e2" {
			(BlB-e2 | BlBxPe2), xe2, !xe2
		}
		key "B%r sac on e2" {
			(BlR-e2 | BlRxPe2), xe2, !xe2
		}
	}
	key "Black sacrifices a piece on f2" {
		key "B%n sac on f2" {
			(BlN-f2 | BlNxPf2), xf2, !xf2
		}
		key "B%b sac on f2" {
			(BlB-f2 | BlBxPf2), xf2, !xf2
		}
		key "B%r sac on f2" {
			(BlR-f2 | BlRxPf2), xf2, !xf2
		}
	}
	key "Black sacrifices a piece on g2" {
		key "B%n sac on g2" {
			(BlN-g2 | BlNxPg2), xg2, !xg2
		}
		key "B%b sac on g2" {
			(BlB-g2 | BlBxPg2), xg2, !xg2
		}
		key "B%r sac on g2" {
			(BlR-g2 | BlRxPg2), xg2, !xg2
		}
	}
	key "Black sacrifices a piece on h2" {
		key "B%n sac on h2" {
			(BlN-h2 | BlNxPh2), xh2, !xh2
		}
		key "B%b sac on h2" {
			(BlB-h2 | BlBxPh2), xh2, !xh2
		}
		key "B%r sac on h2" {
			(BlR-h2 | BlRxPh2), xh2, !xh2
		}
	}
}

key "Some typical formations" {
	key "Isolated White %p on d4" {
		key "White plays d5" {
			(WhPd4 & (WhPc3 == 0 & WhPe3 == 0)),
			WhPd4-d5
		}
		key "White plays %ne5" {
			(WhPd4 & (WhPc3 == 0 & WhPe3 == 0)),
			WhN-e5
		}
		key "White plays %bc4-a2-b1" {
			(WhPd4 & (WhPc3 == 0 & WhPe3 == 0)),
			WhBc4-a2; WhBa2-b1
		}
		key "Black plays %nc6-b4-d5" {
			(WhPd4 & (WhPc3 == 0 & WhPe3 == 0)),
			BlNc6-b4; BlNb4-d5
		}
	}
	key "Isolated Black %p on d5" {
		key "Black plays d4" {
			(BlPd5 & (BlPc6 == 0 & BlPe6 == 0)),
			BlPd5-d4
		}
		key "White plays ?xd5" {
			(BlPd5 & (BlPc6 == 0 & BlPe6 == 0)),
			WhxPd5
		}
	}
	key "Rooks on open c-file" {
		key "White plays %rc7" {
			(Rc? >= 1 & Pc? == 0),
			WhR-c7
		}
		key "White plays %nc5" {
			(Rc? >= 1 & Pc? == 0),
			WhN-c5
		}
		key "White plays %nc6" {
			(Rc? >= 1 & Pc? == 0),
			WhN-c6
		}
	}
	key "White Kingside %p majority 4:3" {
		WhPks == 4 & BlPks == 3
	}
	key "Black Kingside %p majority 4:3" {
		WhPks == 3 & BlPks == 4
	}
	key "White Queenside %p majority 4:3" {
		WhPqs == 4 & BlPqs == 3
	}
	key "Black Queenside %p majority 4:3" {
		WhPqs == 3 & BlPqs == 4
	}
}

key "Attacking castled %k positions" {
	key "White O-O-O, Black O-O" {
		key "Opening Black's g-file" {
			/* either white castles first, or black does.. */
			((WhO-O-O; BlO-O) | (BlO-O; WhO-O-O));
			/* the f7 and h7 pawns haven't moved and the g7
			   pawn captures or gets captured */
			BlPf7 & BlPh7 & (WhxPg7 | BlPg7x)
			
		}
		key "Opening Black's h-file" {
			((WhO-O-O; BlO-O) | (BlO-O; WhO-O-O));
			BlPf7 & BlPg7 & (WhxPh7 | BlPh7x)
		}
		key "Opening Black's g- and h-file" {
			((WhO-O-O; BlO-O) | (BlO-O; WhO-O-O));
			BlPf7 &
			((WhxPg7 | BlPg7x); (WhxPh7 | BlPh7x) |
			(BlPh7- | BlPh7x); (BlPg7- | BlPg7x))
		}
		key "Opening White's a-file" {
			((WhO-O-O; BlO-O) | (BlO-O; WhO-O-O));
			WhPb2 & WhPc2 & (BlxPa2 | WhPa2x)
		}
		key "Opening White's b-file" {
			((WhO-O-O; BlO-O) | (BlO-O; WhO-O-O));
			WhPa2 & WhPc2 & (BlxPb2 | WhPb2x)
		}
		key "Opening White's a- and b-file" {
			((WhO-O-O; BlO-O) | (BlO-O; WhO-O-O));
			WhPc2 &
			((BlxPa2 | WhPa2x); (BlxPb2 | WhPb2x) |
			(BlxPb2 | WhPb2x); (BlxPa2 | WhPa2x))
		}
	}
	key "White O-O, Black O-O" {
		key "Advancing White's f%p" {
			((WhO-O; BlO-O) | (BlO-O; WhO-O));
			/* white attacks with his f-pawn */
			WhPg2 & WhPh2 & WhPf2-
		}
		key "Advancing White's g%p" {
			((WhO-O; BlO-O) | (BlO-O; WhO-O));
			WhPf2 & WhPh2 & WhPg2-
		}
		key "Advancing White's h%p" {
			((WhO-O; BlO-O) | (BlO-O; WhO-O));
			WhPf2 & WhPg2 & WhPh2-
		}
		key "Advancing Black's f%p" {
			((WhO-O; BlO-O) | (BlO-O; WhO-O));
			BlPg7 & BlPh7 & BlPf7-
		}
		key "Advancing Black's g%p" {
			((WhO-O; BlO-O) | (BlO-O; WhO-O));
			BlPf7 & BlPh7 & BlPg7-
		}
		key "Advancing Black's h%p" {
			((WhO-O; BlO-O) | (BlO-O; WhO-O));
			BlPf7 & BlPg7 & BlPh7-
		}
	}
}
