/*
 * Sample Endgame KeySource file.
 *
 * Andy Duplain, Nov 1993.
 */

echo +------------------------+
echo | Endgame KeySource file |
echo +------------------------+

info_tests_only		false
subkey_related		true

/* King and Queen v King */
key "%k + %q v %k" {
	/* White has the Queen */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 1) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Queen */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 1))
}

/* King and Rook v King */
key "%k + %r v %k" {
	/* White has the Rook */
       	((whP == 0 & whB == 0 & whN == 0 & whR == 1 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Rook */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 1 & blQ == 0))
}

/* King and two Bishops v King */
key "%k + 2%b v %k" {
	/* White has the Bishops */
	((whP == 0 & whB == 2 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Bishops */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 2 & blN == 0 & blR == 0 & blQ == 0))
}

/* King and two Knights v King */
key "%k + 2%n v %k" {
	/* White has the Knights */
	((whP == 0 & whB == 0 & whN == 2 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knights */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 2 & blR == 0 & blQ == 0))
}

/* King, Bishop and Knight v King */
key "%k + %b + %n v %k" {
	/* White has the Bishop and Knight */
	((whP == 0 & whB == 1 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Bishop and Knight */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 1 & blN == 1 & blR == 0 & blQ == 0))
}

/* Pawn(s) v Pawn(s) */
key "%p(s) v %p(s)" {
	(whP >= 1 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP >= 1 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)
}

/* Knight v Pawn */
key "%n v %p" {
	/* White has the Knight */
	((whP == 0 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight */
	((whP == 1 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n v 2%p" {
	/* White has the Knight */
	((whP == 0 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight */
	((whP == 2 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n v 3%p" {
	/* White has the Knight */
	((whP == 0 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 3 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight */
	((whP == 3 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n + %p v %k" {
	/* White has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and Pawn */
	((whP == 0 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n + %p v %p" {
	/* White has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n + %p v 2%p" {
	/* White has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and Pawn */
	((whP == 2 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n + %p v 3%p" {
	/* White has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 3 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and Pawn */
	((whP == 3 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n + %p v 4%p" {
	/* White has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 4 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and Pawn */
	((whP == 4 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}
key "%n + 2%p v 2%p" {
	/* White has the Knight and two Pawn */
	((whP == 2 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and two Pawn */
	((whP == 2 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}

key "%n + 3%p v %p(s)" {
	/* White has the Knight and three Pawn */
	((whP == 3 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP >= 1 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and three Pawn */
	((whP >= 1 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 3 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}

/* Knight v Knight */

key "%n + %p v %n" {
	/* White has the Knight and Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and Pawn */
	((whP == 0 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}

key "%n + %p v %n + %p" {
	(whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)
}

key "%n + 2%p v %n" {
	/* White has the Knight and two Pawn */
	((whP == 2 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and two Pawn */
	((whP == 0 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}

key "%n + 2%p v %n + %p" {
	/* White has the Knight and two Pawns */
	((whP == 2 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and two Pawns */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}

key "%n + 2%p v %n + 2%p" {
	(whP == 2 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 2 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)
}

key "%n + 3%p v %n + %p" {
	/* White has the Knight and three Pawn */
	((whP == 3 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)) |
	/* Black has the Knight and three Pawn */
	((whP == 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP == 3 & blB == 0 & blN == 1 & blR == 0 & blQ == 0))
}

key "%n + %ps v %n + %ps" {
	(whP > 1 & whB == 0 & whN == 1 & whR == 0 & whQ == 0) &
	(blP > 1 & blB == 0 & blN == 1 & blR == 0 & blQ == 0)
}

/* Two Knights v Pawn */

key "2%n v %p(s)" {
	/* White has the two Knights */
	((whP == 0 & whB == 0 & whN == 2 & whR == 0 & whQ == 0) &
	(blP >= 1 & blB == 0 & blN == 0 & blR == 0 & blQ == 0)) |
	/* Black has the two Knights */
	((whP >= 1 & whB == 0 & whN == 0 & whR == 0 & whQ == 0) &
	(blP == 0 & blB == 0 & blN == 2 & blR == 0 & blQ == 0))
}

/* UNFINISHED */
