#include "global.h"
#include <ctype.h>

int xatol_err = 0;
char *xatol_ptr = NULL;

/*
 * XATOL
 *
 * Convert ASCII to long.  If a non-decimal digit is found the flag
 * "xatol_err" is set to 1, and the pointer "xatol_ptr" is set the address
 * of the offending character.  The value parsed upto the time of an error
 * is returned anyway.
 */
long
xatol(s)
    char *s;
{
    long ret;
    int minus;

    ret = 0L;
    minus = 0;
    xatol_err = 0;
    xatol_ptr = NULL;

    if (!*s) {
        xatol_err = 1;
        xatol_ptr = s;
        return 0L;
    }
    if (*s == '-') {
        minus++;
        s++;
    } else if (*s == '+') {
        minus = 0;
        s++;
    }
    while (*s && isdigit(*s)) {
        ret *= 10L;
        ret += *s - '0';
        s++;
    }

    if (*s) {
        xatol_err = 1;
        xatol_ptr = s;
    }
    return ret;
}
