#include "global.h"

/*
 * WRITE_INFO
 *
 * Write game header, player and source info.
 */
int
write_info(db, game)
    Database db;
    Game game;
{
    register int i;
    u_char *hdr;
    int len, xor_mask, eco1, eco2;

    hdr = game->header;

 /* encode year */
    if (game->year)
        hdr[0] = (char) (game->year - 1900);
    else
        hdr[0] = 127;

 /* encode ELO */
    if (game->w_elo)
        hdr[8] = (u_char) ((game->w_elo - 1600) / 5);
    else
        hdr[8] = 0;

    if (game->b_elo)
        hdr[9] = (u_char) ((game->b_elo - 1600) / 5);
    else
        hdr[9] = 0;

 /* encode ECO */
    if (is_full(hdr)) {
        if (game->eco_letter) {
            eco1 = ((game->eco_letter - 'A') * 100) +
              game->eco_main + 1;
            eco2 = game->eco_sub;
        } else {
            eco1 = 0;
            eco2 = 0;
        }
        set_eco1(hdr, eco1);
        set_eco2(hdr, eco2);
    }
 /* encode lengths */
    if (game->plen > 47)
        game->plen = 47;
    set_plen(hdr, game->plen);
    if (game->slen > 47)
        game->slen = 47;
    set_slen(hdr, game->slen);
    s2c(&hdr[2], (u_short)(game->mlen + 1));
    s2c(&hdr[6], game->clen);

 /* encode miscellaneous */
    set_nmoves(hdr, game->nmoves);
    if (is_partial(hdr)) {
        set_tomove(hdr, to_colour(game->halfmove));
        set_ep(hdr, game->ep);
    }
    if (write_header(db, game) < 0)
        return -1;

 /* encode and write player and source info */
    len = game->plen + game->slen;
    if (len) {
        bcopy((char *) game->pinfo, (char *) gamebuf, game->plen);
        bcopy((char *) game->sinfo, (char *) gamebuf + game->plen,
          game->slen);
        for (i = len - 1, xor_mask = 3 * len; i >= 0; i--) {
            gamebuf[i] ^= xor_mask;
            xor_mask *= 3;
        }
        if (file_write(db->cbf, (char *) gamebuf, len) != len) {
            return -1;
        }
    }
    return 0;
}
