#include "global.h"

/*
 * WRITE_HEADER
 *
 * Write game header.
 */
int
write_header(db, game)
    Database db;
    Game game;
{
    register int i;
    u_char buf[14];
    int xor_mask;

    bcopy((char *) game->header, (char *) buf, 14);

    buf[11] |= 0x40;                   /* set version bit */

 /* calculate checksum */
    buf[13] = (buf[3] * 0x1ec1 * (buf[8] + 1) * buf[0]) & 0xff;

 /* encode data */
    buf[11] ^= 14 + (buf[4] & 0x3f) + (buf[5] & 0x3f);
    for (i = 13, xor_mask = 101; i >= 0; i--) {
        buf[i] ^= xor_mask;
        xor_mask *= 3;
    }

    if (file_write(db->cbf, (char *) buf, 14) != 14)
        return -1;
    return 0;
}
