#include "global.h"

int write_gap = 0;

/*
 * WRITE_GAME
 *
 * Write a ChessBase game
 */
int
write_game(db, game)
    Database db;
    Game game;
{
    register int i, j;
    int xor_mask, len;
    u_char piece, *tmp;

    if (write_info(db, game) < 0)
        return 0;

 /* encode and write moves */
    if (game->mlen) {
        len = game->mlen;
        tmp = (u_char *) mem_alloc(len);
        if (!tmp)
            return -1;
        bcopy((char *) game->moves, (char *) tmp, len);
        len++;
        for (i = len - 2, xor_mask = len * 49; i > 0; i--) {
            tmp[i] ^= xor_mask;
            xor_mask *= 7;
        }
        len--;
        if (file_write(db->cbf, (char *) tmp, len) != len) {
            free(tmp);
            return -1;
        }
        free(tmp);
    }
 /* write comments */
    if (game->clen) {
        len = game->clen;
        if (file_write(db->cbf, (char *) game->comments, len) != len)
            return -1;
    }
 /* write partial board */
    if (is_partial(game->header)) {
        for (i = 0; i < 8; i++) {      /* rank */
            for (j = 0; j < 8; j += 2) {        /* file */
                piece = game->board[to_offset(j, i)] << 4;
                piece |= game->board[to_offset(j + 1, i)] & 0xf;
                gamebuf[i * 4 + j / 2] = piece;
            }
        }
        if (file_write(db->cbf, (char *) gamebuf, 32) != 32) {
            return -1;
        }
        file_putc(db->cbf, to_move(game->halfmove) - 1);
    }

 /* write "gap" */
	if (write_gap)
		for (j = 0; j < write_gap; j++)
			file_putc(db->cbf, 0);

 /* write the index entry for the next game */
    write_index(db, game->num + 1L, file_tell(db->cbf));
}
