#include "global.h"
#include "syms.h"

/* general symbols */
char null[] = "";
static char a[] = "a";
static char e[] = "e";
static char i[] = "i";
static char o[] = "o";
static char u[] = "u";
static char kside[] = ">> ";
static char qside[] = "<< ";
static char w_advantage[] = "+- ";
static char w_winning[] = "+/- ";
static char w_better[] = "+/= ";
static char equality[] = "= ";
static char unclear[] = "& ";
static char b_better[] = "=/+ ";
static char b_winning[] = "-/+ ";
static char b_advantage[] = "-+ ";
static char w_compensation[] = "&/= ";
static char b_compensation[] = "=/& ";
static char counter_play[] = "<-/-> ";
static char initiative[] = "^ ";
static char attack[] = "-> ";
static char time_trouble[] = "(+) ";
static char forced[] = "[] ";
static char zugzwang[] = "(.) ";
static char develop_adv[] = "<dev.adv.> ";
static char worse_is[] = ">= ";
static char better_is[] = "<= ";
char with_idea[] = "/\\ ";
static char editor_comment[] = "RR ";
static char dot[] = ".";

char *sym[NSYMS] = {
    "C",                               /* 128 - Cedille C */
    "ue",                              /* 129 - Umlaut u */
    e,                                 /* 130 - Acute e */
    a,                                 /* 131 - Circumflex a */
    "ae",                              /* 132 - Umlaut a */
    a,                                 /* 133 - Grave a */
    a,                                 /* 134 - Dot a */
    "c",                               /* 135 - Cedille c */
    e,                                 /* 136 - Circumflex e */
    e,                                 /* 137 - Umlaut e */
    e,                                 /* 138 - Grave e */
    i,                                 /* 139 - Umlaut i */
    i,                                 /* 140 - Circumflex i */
    i,                                 /* 141 - Grave i */
    "Ae",                              /* 142 - Umlaut A */
    "A",                               /* 143 - Dot A */
    "E",                               /* 144 - Acute E */
    "ae",                              /* 145 - Scandi. ae */
    "AE",                              /* 146 - Scandi. AE */
    o,                                 /* 147 - Circumflex o */
    "oe",                              /* 148 - Umlaut o */
    o,                                 /* 149 - Grave o */
    u,                                 /* 150 - Circumflex u */
    u,                                 /* 151 - Grave u */
    "y",                               /* 152 - Umlaut y */
    "Oe",                              /* 153 - Umlaut O */
    "Ue",                              /* 154 - Umlaut U */
    null,                              /* 155 - */
    "#",                               /* 156 - */
    null,                              /* 157 - */
    "ss",                              /* 158 - German S */
    null,                              /* 159 - */
    a,                                 /* 160 - Acute a */
    i,                                 /* 161 - Acute i */
    o,                                 /* 162 - Acute o */
    u,                                 /* 163 - Acute u */
    "n",                               /* 164 - Tilde n */
    "N",                               /* 165 - Tilde N */
    null,                              /* 166 - */
    null,                              /* 167 - */
    null,                              /* 168 - */
    null,                              /* 169 - */
    null,                              /* 170 - */
    "1/2",                             /* 171 - */
    "1/4",                             /* 172 - */
    null,                              /* 173 - */
    qside,                             /* 174 - */
    kside,                             /* 175 - */
    "|| ",                             /* 176 - Etc */
    "K",                               /* 177 - King */
    "Q",                               /* 178 - Queen */
    "N",                               /* 179 - Knight */
    "B",                               /* 180 - Bishop */
    "R",                               /* 181 - Rook */
    "P",                               /* 182 - Pawn */
    "1/4 ",                            /* 183 - Quarter */
    "1/2 ",                            /* 184 - Half */
    "3/4 ",                            /* 185 - Three Quarters */
    null,                              /* 186 - */
    w_winning,                         /* 187 - White is winning */
    w_better,                          /* 188 - White is slightly better */
    w_compensation,                    /* 189 - White has compensation */
    unclear,                           /* 190 - Unclear */
    b_compensation,                    /* 191 - Black has compensation */
    b_better,                          /* 192 - Black is slightly better */
    b_winning,                         /* 193 - Black is winning */
    "<pair-B> ",                       /* 194 - Bishop Pair */
    "<opp-B> ",                        /* 195 - Opposite Bishops */
    "<same-B> ",                       /* 196 - Same Bishops */
    worse_is,                          /* 197 - Worse Is */
    better_is,                         /* 198 - Better Is */
    better_is,                         /* 199 - Better Is */
    "<spc.adv.> ",                     /* 200 - Space Advantage */
    forced,                            /* 201 - Forced (Only move) */
    with_idea,                         /* 202 - With Idea */
    qside,                             /* 203 - Queenside */
    kside,                             /* 204 - Kingside */
    kside,                             /* 205 - Kingside */
    qside,                             /* 206 - Queenside */
    initiative,                        /* 207 - With Initiative */
    attack,                            /* 208 - With Attack */
    counter_play,                      /* 209 - With Counterplay */
    "/ ",                              /* 210 - Diagonal */
    "[+] ",                            /* 211 - Centre */
    "<=> ",                            /* 212 - File */
    "_|_ ",                            /* 213 - Endgame */
    "X ",                              /* 214 - Weak Point */
    zugzwang,                          /* 215 - Zugzwang */
    time_trouble,                      /* 216 - Time Trouble */
    "o",                               /* 217 - Pawn Evaluation */
    "..",                              /* 218 - United pawns */
    "<dbl-P> ",                        /* 219 - Doubled Pawn */
    "<pass-P> ",                       /* 220 - Passed Pawn */
    "with ",                           /* 221 - with */
    "without ",                        /* 222 - without */
    develop_adv,                       /* 223 - Development Advantage */
    null,                              /* 224 - */
    "ss",                              /* 225 - German S */
    null,                              /* 226 - */
    null,                              /* 227 - */
    null,                              /* 228 - */
    null,                              /* 229 - */
    null,                              /* 230 - */
    null,                              /* 231 - */
    null,                              /* 232 - */
    null,                              /* 233 - */
    null,                              /* 234 - */
    null,                              /* 235 - */
    unclear,                           /* 236 - Unclear */
    null,                              /* 237 - */
    null,                              /* 238 - */
    null,                              /* 239 - */
    null,                              /* 240 - */
    w_winning,                         /* 241 - White is winning */
    worse_is,                          /* 242 - Worse is */
    better_is,                         /* 243 - Better is */
    null,                              /* 244 - */
    null,                              /* 245 - */
    null,                              /* 246 - */
    null,                              /* 247 - */
    dot,                               /* 248 - */
    dot,                               /* 249 - */
    dot,                               /* 250 - */
    null,                              /* 251 - */
    null,                              /* 252 - */
    null,                              /* 253 - */
    " ",                               /* 254 - Next Line */
    null                               /* 255 - */
};

/* evaluation symbols */
char *eval[NEVALS] = {
    null,
    "!",                               /* Good move */
    "?",                               /* Bad move */
    "!?",                              /* Interesting move */
    "?!",                              /* Dubious move */
    "!!",                              /* Brilliant move */
    "??",                              /* Blunder */
    "#",                               /* Mate */
    zugzwang,                          /* Zugzwang */
    develop_adv                        /* Development advantage */
};

/* position evaluation symbols */
char *poseval[NPOSEVALS] = {
    null,
    w_advantage,                       /* White has advantage */
    w_winning,                         /* White is winning */
    w_better,                          /* White is slightly better */
    equality,                          /* Equality */
    unclear,                           /* unclear */
    b_better,                          /* Black is slightly better */
    b_winning,                         /* Black is winning */
    b_advantage,                       /* Black has advantage */
    "N",                               /* Novelty */
    b_compensation,                    /* Black has compensation */
    counter_play,                      /* With counter play */
    initiative,                        /* With initiative */
    attack,                            /* With attack */
    time_trouble,                      /* Time trouble */
    forced                             /* Forced (only move) */
};

char *moveval[NMOVEVALS] = {
    null,
    editor_comment,                    /* Editorial comment */
    better_is,                         /* Better is */
    with_idea,                         /* With the idea */
    "~=",                              /* Roughly equal */
    worse_is,                          /* Worse is */
    better_is,                         /* Better is */
    "<H>"                              /* ? */
};

char cvtbuf[1024];
