#include "global.h"
#include <ctype.h>

/*
 * READ_LISTFILE
 *
 * Read a list of databases from a listfile
 */
char *
read_listfile(fp)
    FILE *fp;
{
    static char buffer[128];
    int c, i;

    i = 0;
    while ((c = fgetc(fp)) != EOF) {
        if (isspace(c))
            continue;
        if (c == '#') {
            while ((c = fgetc(fp)) != EOF)
                if (c == '\n')
                    break;
            if (c == EOF)
                return NULL;
            continue;
        }
        buffer[0] = c;
        for (i = 1; i < sizeof(buffer) - 1; i++) {
            if ((c = fgetc(fp)) == EOF)
                break;
            if (!isspace(c) && c != '#')
                buffer[i] = c;
            else
                break;
        }
        buffer[i] = '\0';
        if (c == '#')
            ungetc(c, fp);
        if (i) {
            kill_ext(buffer);
            strlower(buffer);
            return buffer;
        } else {
            return NULL;
        }
    }
    return NULL;
}
