#include "global.h"

/*
 * READ_INFO
 *
 * Read game header, player and source info.
 */
int
read_info(db, game)
    Database db;
    Game game;
{
    register int i;
    u_char *hdr;
    int status;
    int len, xor_mask;
    int eco1;

    if ((status = read_header(db, game)) < 0)
        return status;

    hdr = game->header;

 /* decode year */
    if (hdr[0] == 127)
        game->year = 0;
    else
        game->year = 1900 + (char) hdr[0];

 /* decode ELO values */
    if (hdr[8])
        game->w_elo = ((int) hdr[8] * 5) + 1600;
    else
        game->w_elo = 0;

    if (hdr[9])
        game->b_elo = ((int) hdr[9] * 5) + 1600;
    else
        game->b_elo = 0;

 /* decode ECO */
    game->eco_letter = 0;
    game->eco_main = 0;
    game->eco_sub = 0;
    if (is_full(hdr)) {
        eco1 = get_eco1(hdr);
        if (eco1) {
            game->eco_letter = ((eco1 - 1) / 100) + 'A';
            game->eco_main = (eco1 - 1) % 100;
            game->eco_sub = get_eco2(hdr);
        }
    }
 /* decode lengths */
    game->plen = get_plen(hdr);
    game->slen = get_slen(hdr);
    game->mlen = c2s(&hdr[2]) - 1;
    game->clen = c2s(&hdr[6]);

    game->pinfo[0] = '\0';
    game->sinfo[0] = '\0';
    game->nmoves = get_nmoves(hdr);

 /* read and decode player and source info */
    len = game->plen + game->slen;
    if (len) {
        if (file_read(db->cbf, (char *) gamebuf, len) != len)
            return -1;

        for (i = len - 1, xor_mask = 3 * len; i >= 0; i--) {
            gamebuf[i] ^= xor_mask;
            xor_mask *= 3;
        }
        bcopy((char *) gamebuf, (char *) game->pinfo, game->plen);
        game->pinfo[game->plen] = '\0';
        bcopy((char *) gamebuf + game->plen, (char *) game->sinfo,
          game->slen);
        game->sinfo[game->slen] = '\0';
    }
    return 0;
}
