#include "global.h"

/*
 * READ_HEADER
 *
 * Read game header.
 *
 * Returns: 0 if no error, -1 if read error, -2 if checksum incorrect.
 */
int
read_header(db, game)
    Database db;
    Game game;
{
    register int i;
    u_char *buf;
    int xor_mask;

    seek_game(db, game);

    buf = game->header;

    if (file_read(db->cbf, (char *) buf, 14) != 14)
        return -1;

    for (i = 13, xor_mask = 101; i >= 0; i--) {
        buf[i] ^= xor_mask;
        xor_mask *= 3;
    }
    buf[11] ^= 14 + (buf[4] & 0x3f) + (buf[5] & 0x3f);

 /* check checksum */
    if ((int) ((buf[0] * 0x25 + buf[5] + buf[9]) & 0xff) != (int) buf[13]
      && (int) ((buf[3] * 0x1ec1 * (buf[8] + 1) * buf[0]) & 0xff)
      != (int) buf[13]) {
        chksum_err = 1;
        if (!ignore_chksum_err) {
            error("game %lu: checksum error", game->num);
            return -2;
        }
    }
    chksum_err = 0;

    return 0;
}
