#include "global.h"
#include <ctype.h>

static int extract_round_number P__((GameSort game, char *s));
static int remove_annotator P__((char *s));

/*
 * READ_GAME_SORT
 *
 * Read a game from the database for sorting.
 */
int
read_game_sort(db, num, game)
    Database db;
    u_long num;
    register GameSort game;
{
    register int i;
    int xor_mask, plen, slen, len;
    u_char hdr[14], *cptr;

    bzero((char *) game, sizeof(struct game_sort));

    game->index = read_index(db, num);
    file_seek(db->cbf, game->index);

    if (file_read(db->cbf, (char *) hdr, 14) != 14)
        return -1;

    for (i = 13, xor_mask = 101; i >= 0; i--) {
        hdr[i] ^= xor_mask;
        xor_mask *= 3;
    }
    hdr[11] ^= 14 + (hdr[4] & 0x3f) + (hdr[5] & 0x3f);

 /* check checksum */
    if ((int) ((hdr[0] * 0x25 + hdr[5] + hdr[9]) & 0xff) != (int) hdr[13]
      && (int) ((hdr[3] * 0x1ec1 * (hdr[8] + 1) * hdr[0]) & 0xff)
      != (int) hdr[13]) {
        chksum_err = 1;
        if (!ignore_chksum_err) {
            error("game %lu: checksum error", num);
            return -2;
        }
    }
    chksum_err = 0;

    if (hdr[0] != 127)
        game->year = 1900 + (char) hdr[0];

    if (is_full(hdr))
        game->eco = get_eco1(hdr);

    game->nmoves = get_nmoves(hdr);

    plen = get_plen(hdr);
    slen = get_slen(hdr);
    len = plen + slen;
    if (len) {
        if (file_read(db->cbf, (char *) gamebuf, len) != len)
            return -1;

        for (i = len - 1, xor_mask = len * 3; i >= 0; i--) {
            gamebuf[i] ^= xor_mask;
            xor_mask *= 3;
        }

        bcopy((char *) gamebuf, (char *) game->pinfo, plen);
        game->pinfo[plen] = '\0';
        bcopy((char *) gamebuf + plen, (char *) game->sinfo, slen);
        game->sinfo[slen] = '\0';

        cptr = (u_char *) index((char *) game->pinfo, '-');
        if (cptr) {
            game->wplayer_len = cptr - game->pinfo;
            game->bplayer_off = game->wplayer_len + 1;
        } else {
            game->wplayer_len = ustrlen(game->pinfo);
        }
    }
 /* look for round number in players field then source field. */
    if (plen && !extract_round_number(game, (char *) game->pinfo))
        if (slen)
            extract_round_number(game, (char *) game->sinfo);

 /* remove the annotator from the sinfo field */
    remove_annotator((char *) game->sinfo);

 /* tidy the strings to make sorting "more correct" */
    tidy_string((char *) game->pinfo);
    tidy_string((char *) game->sinfo);

#if 0
    printf("pinfo=\"%s\" sinfo=\"%s\" round[0]=%d round[1]=%d round[2]=%d\n",
      game->pinfo, game->sinfo, game->round[0], game->round[1], game->round[2]);
#endif

    return 0;
}

/*
 * EXTRACT_ROUND_NUMBER
 *
 * Find the round number (digits/periods/slashes in brackets) in a string
 * remove it from the string.
 *
 * Returns 1 if a round number was found.
 */
static int
extract_round_number(game, s)
    GameSort game;
    char *s;
{
    char *anchor, *end, c;
    int i, valid, mslash;

    game->round[0] = 0;
    game->round[1] = 0;
    game->round[2] = 0;

    while (*s) {
        if (*s == '(') {
            anchor = s++;
            valid = 1;
        /* allow "(m/X)" */
            if (*s == 'm' && *(s + 1) == '/') {
                s += 2;
                mslash = 1;
            } else {
                mslash = 0;
            }
            while (*s && *s != ')') {
                c = *s++;
                if (!isdigit(c) && c != '.' && c != '/'
                  && c != '\\') {
                    valid = 0;
                    break;
                }
            }
            if (valid && *s == ')') {
                end = s + 1;

            /* remove the round numbers from between the parathesis and
               seperators */
                i = 0;
                s = anchor;
                if (mslash)
                    s += 2;
                while (s < end && i < 3) {
                    if (isdigit(*s)) {
                        char *new_s;
                        game->round[i] =
                          (u_short) strtol(s, &new_s, 10);
                        s = new_s;
                        i++;
                    }
                    s++;
                }

            /* remove the round text from the string */
                while (*anchor++ = *end++);

                return 1;
            }
        }
        s++;
    }
    return 0;
}

/*
 * REMOVE_ANNOTATOR
 *
 * Remove the annotator (within square brackets) name from a field.
 */
static int
remove_annotator(s)
    char *s;
{
    char *anchor;

    while (*s) {
        if (*s == '[') {
            anchor = s;
            while (*s && *s != ']')
                s++;
            if (*s == ']') {
                s++;
            /* remove the text */
                while (*anchor++ = *s++);
                return 1;
            }
        }
        s++;
    }
    return 0;
}
