#include "global.h"

/*
 * READ_GAME
 *
 * Read a ChessBase game.
 */
int
read_game(db, game)
    Database db;
    Game game;
{
    register int i, j;
    int status, len, xor_mask;
    u_char piece;

    if ((status = read_info(db, game)) < 0)
        return status;

 /* read and decode the moves */
    if (game->mlen) {
        len = game->mlen;
        game->moves = (u_char *) mem_alloc(len);
        if (!game->moves)
            return -1;
        if (file_read(db->cbf, (char *) game->moves, len) != len)
            return -1;

        len++;                         /* un-adjust */
        for (i = len - 2, xor_mask = len * 49; i > 0; i--) {
            game->moves[i] ^= xor_mask;
            xor_mask *= 7;
        }
    }
 /* read comments */
    if (game->clen) {
        len = game->clen;
        game->comments = (u_char *) mem_alloc(len);
        if (!game->comments)
            return -1;
        if (file_read(db->cbf, (char *) game->comments, len) != len)
            return -1;
    }
 /* read partial board */
    if (is_partial(game->header)) {
        if (file_read(db->cbf, (char *) gamebuf, 32) != 32)
            return -1;

        for (i = 0; i < 8; i++) {      /* rank */
            for (j = 0; j < 8; j += 2) {        /* file */
                piece = gamebuf[i * 4 + j / 2];
                game->board[to_offset(j, i)] = piece >> 4;
                game->board[to_offset(j + 1, i)] = piece & 0xf;
            }
        }

        game->ep = get_ep(game->header);
        i = file_getc(db->cbf) + 1;    /* initial move number */
        j = get_tomove(game->header);  /* 0 for white, 1 for black */
        game->halfmove = to_halfmove(i, j);
    } else {                           /* full game */
        game->ep = 0;
        game->halfmove = 1;
        init_board(game->board);
    }
	copy_board(game->board, cb_board);

    return 0;
}
