#include "global.h"

static Game dgm_game;
static int dgm_movepos, maxmove;
static int (*dgm_func) P__((int halfmove));
static int ret;
static u_char *moveptr;

static int do_game_move P__((int halfmove));

/*
 * PROCESS_MOVES
 *
 * Extract every move from a game, generate the movelist and board for each
 * move and call a user-defined function for each move.  If the user-defined
 * function returns non-zero, then processing stops and that value is
 * returned to the caller.
 */
int
process_moves(game, func)
    Game game;
    int (*func) P__((int halfmove));
{
    dgm_game = game;
    dgm_movepos = 0;
    dgm_func = func;
    var_level = 0;
    ret = 0;
    maxmove = game->mlen;
    moveptr = game->moves;
    copy_board(game->board, cb_board);
    cb_enpassant = game->ep;
    return do_game_move(game->halfmove);
}

/*
 * DO_GAME_MOVE
 *
 * Process a single line (recursive).
 */
static int
do_game_move(halfmove)
    int halfmove;
{
    register int movenum;
    u_char saved_board[64], prev_board[64];
    int saved_enpassant, prev_enpassant;

    copy_board(cb_board, prev_board);
    prev_enpassant = cb_enpassant;

    while (dgm_movepos < maxmove) {

        movenum = *moveptr++;
        dgm_movepos++;

        if (movenum == 0x80) {         /* end of variation */

            if (!var_level) {
                error("game %lu (h=%d, v=%d): spurious variation-end marker",
                  dgm_game->num, halfmove, var_level);
                return -1;
            }
            if (dgm_func) {
                ret = dgm_func(END_VAR_SIGNAL);
                if (ret)
                    return ret;
            }
            var_level--;
            return 0;

        } else if (movenum == 0xff) {  /* start of variation */

            if (dgm_func) {
                ret = dgm_func(START_VAR_SIGNAL);
                if (ret)
                    return ret;
            }
        /* save current (main line) board and ep mask and copy in previous
           board and ep mask */
            copy_board(cb_board, saved_board);
            saved_enpassant = cb_enpassant;
            copy_board(prev_board, cb_board);
            cb_enpassant = prev_enpassant;
            var_level++;
            ret = do_game_move(halfmove - 1);
            if (ret)
                return ret;
        /* restore main line board and ep mask */
            copy_board(saved_board, cb_board);
            cb_enpassant = saved_enpassant;

        } else {                       /* ordinary move */

        /* save a copy of the previous board and ep mask for any future
           variations */
            copy_board(cb_board, prev_board);
            prev_enpassant = cb_enpassant;

            comment = movenum & 0x80;
            movenum = (movenum & 0x7f) - 1;     /* base zero for move list */

            gen_movelist(to_colour(halfmove));

            if (movenum >= moveidx) {
                error("game %lu (h=%d, v=%d): move number (%d) out of range",
                  dgm_game->num, halfmove, var_level, movenum);
                return -1;
            }
            lastmove = movelist[movenum];
            lastmove_num = movenum;

            do_move(lastmove.from, lastmove.to, lastmove.prom);

#if 0
            printf("%c %d v=%d movenum=%d move=%s\n", to_colour(halfmove) ? 'B' : 'W',
              to_move(halfmove), var_level, movenum,
			  format_move(lastmove.from, lastmove.to, lastmove.prom));
#endif

            if (dgm_func) {
                ret = dgm_func(halfmove);
                if (ret)
                    return ret;
            }
            halfmove++;
        }
    }

    return 0;
}
