#include "global.h"

/*
 * OUTPUT
 *
 * Write a message to the screen.
 *
 * Returns the number of characters printed.
 */
#ifdef ANSI_C
int
output(char *fmt,...)
{
    va_list ap;
    int ret;

    va_start(ap, fmt);
    ret = vfprintf(stdout, fmt, ap);
    va_end(ap);
    fflush(stdout);
    return ret;
}
#else                                  /* ANSI_C */
int
output(va_alist)
va_dcl
{
    va_list ap;
    char *fmt;
    int ret;

    va_start(ap);
    fmt = va_arg(ap, char *);
    ret = vfprintf(stdout, fmt, ap);
    va_end(ap);
    fflush(stdout);
    return ret;
}
#endif                                 /* ANSI_C */
