#include "global.h"

/*
 * OPEN_DATABASE
 *
 * Open a ChessBase database.
 */
Database
open_database(name)
    char *name;
{
    Database db;
    char *filename;

    db = (Database) mem_alloc(sizeof(struct database));
    if (!db)
        return NULL;

 /* open the games file (.CBF) */
    filename = derive_name(name, ".cbf");
    if (!filename)
        goto failed;
    db->cbf = file_open(filename, "r+b");
    free(filename);
    if (!db->cbf)
        goto failed;

 /* open the index file (.CBI) */
    filename = derive_name(name, ".cbi");
    if (!filename)
        goto failed;
    db->cbi = file_open(filename, "r+b");
    free(filename);
    if (!db->cbi)
        goto failed;

 /* read the "number of games" value from the index file */
    read_ngames(db);

    return db;

failed:
    close_database(db);
    return NULL;
}
