#include "global.h"

/*
 * ALGEBRAIC
 *
 * Return the algebraic notation for the move just made.
 */
char *
algebraic(colour)
    int colour;
{
    register int i;
    Move tmove;
    u_char cpiece, piece;
    char ambig_file, ambig_rank;
    static char notation[16];

    ambig_file = 0;
    ambig_rank = 0;

    if (colour)
        colour = 8;
    if (lastmove_flags == SHORT_CASTLE) {
        strcpy(notation, "O-O");
        i = 3;
    } else if (lastmove_flags == LONG_CASTLE) {
        strcpy(notation, "O-O-O");
        i = 5;
    } else {
    /* normal move */
        if (lastmove.prom) {
            cpiece = PAWN | colour;
            piece = PAWN;
        } else {
            cpiece = cb_board[lastmove.to];
            piece = cpiece & 7;
        }

    /* find any other pieces that could move into the same square */
        if (piece != PAWN) {
            for (i = 0; i < moveidx; i++) {
                if (i == lastmove_num)
                    continue;
                tmove = &movelist[i];
                if ((tmove->to == lastmove.to) &&
                  (cb_board[tmove->from] == cpiece)) {
                /* ambiguity (may be file, rank or both) */
                    if (to_rank(lastmove.from) == to_rank(tmove->from))
                        ambig_file = to_file(lastmove.from) + 'a';
                    if (to_file(lastmove.from) == to_file(tmove->from))
                        ambig_rank = to_rank(lastmove.from) + '1';
                    if (!ambig_file && !ambig_rank)
                        ambig_file = to_file(lastmove.from) + 'a';
                }
            }
        }
        i = 0;

        if (piece == PAWN) {
            if (lastmove_flags & CAPTURE)
                notation[i++] = to_file(lastmove.from) + 'a';
        } else {
            notation[i++] = piece_list[piece];
        }
        if (ambig_file)
            notation[i++] = ambig_file;
        if (ambig_rank)
            notation[i++] = ambig_rank;
        if (lastmove_flags & CAPTURE)
            notation[i++] = 'x';
        notation[i++] = to_file(lastmove.to) + 'a';
        notation[i++] = to_rank(lastmove.to) + '1';
        if (lastmove.prom) {
            notation[i++] = '=';
            notation[i++] = piece_list[lastmove.prom];
        }
    }

    if (is_check(colour)) {
        if (is_mate(colour))
            notation[i++] = '#';
        else
            notation[i++] = '+';
    }
    notation[i] = '\0';
    return notation;
}
