#include "global.h"

/* movetype template/token table */
struct movetype {
	char *typestr;	/* f=file, r=rank, p=piece, P=promotion, x=capture */
	MoveToken token;
};
static struct movetype movetypes[] = {
	{ "fr",		MT_PAWN_MOVE },
	{ "frP",	MT_PAWN_MOVE_P },
	{ "fxfr",	MT_PAWN_CAPTURE },
	{ "ffr",	MT_PAWN_CAPTURE },
	{ "fxfrP",	MT_PAWN_CAPTURE_P },
	{ "ffrP",	MT_PAWN_CAPTURE_P },
	{ "fxfP",	MT_PAWN_CAPTURE_SHORT_P },
	{ "ffP",	MT_PAWN_CAPTURE_SHORT_P },
	{ "fxf",	MT_PAWN_CAPTURE_SHORT },
	{ "ff",     MT_PAWN_CAPTURE_SHORT },
	{ "pfr",	MT_PIECE_MOVE },
	{ "pffr",	MT_PIECE_MOVE_F },
	{ "prfr",	MT_PIECE_MOVE_R },
	{ "pfrfr",	MT_PIECE_MOVE_FR },
	{ "pxfr",	MT_PIECE_CAPTURE },
	{ "pfxfr",	MT_PIECE_CAPTURE_F },
	{ "prxfr",	MT_PIECE_CAPTURE_R },
	{ "pfrxfr",	MT_PIECE_CAPTURE_FR }
};
#define NMOVETYPES (sizeof(movetypes) / sizeof(movetypes[0]))

static char *qscastle_list[] = {
	"o-o-o", "O-O-O", "0-0-0", "ooo", "OOO", "000"
};
#define NQSCASTLE_LIST (sizeof(qscastle_list) / sizeof(qscastle_list[0]))

static char *kscastle_list[] = {
	"o-o", "O-O", "0-0", "oo", "OO", "00"
};
#define NKSCASTLE_LIST (sizeof(kscastle_list) / sizeof(kscastle_list[0]))

/*
 * GET_MOVE_TOKEN
 *
 * Determine the type of the move, and whether the check or mate indicator
 * exists.
 */
MoveToken
get_move_token(s)
	char *s;
{
	int i, fail;
	char *tptr, *cptr;

	/* try castling first */
	for (i = 0; i < NQSCASTLE_LIST; i++) {
		if (strncmp(s, qscastle_list[i], strlen(qscastle_list[i])) == 0) {
			return MT_QSIDE_CASTLE;
		}
	}
	for (i = 0; i < NKSCASTLE_LIST; i++) {
		if (strncmp(s, kscastle_list[i], strlen(kscastle_list[i])) == 0) {
			return MT_KSIDE_CASTLE;
		}
	}

	/* look in table for move type */
	for (i = 0; i < NMOVETYPES; i++) {
		tptr = movetypes[i].typestr;
		cptr = s;
		fail = 0;
		while (*tptr && !fail) {
			switch(*tptr) {
			case 'f':		/* file */
				fail = !isfilelet(*cptr);
				break;
			case 'r':
				fail = !isranknum(*cptr);
				break;
			case 'p':
				fail = !ispiece(*cptr);
				break;
			case 'P':
				if (*cptr != '=' || !ispiece(*(cptr+1)))
					fail++;
				cptr++;
				break;
			case 'x':
				fail = *cptr != 'x';
				break;
			default:
				return MT_ERROR;
			}
			tptr++;
			cptr++;
		}
		if (!fail)
			return movetypes[i].token;
	}
	return MT_ERROR;
}
