#include "global.h"

static int king_offset = 0xff;         /* set if checking for check */
static int in_check;                   /* set if found check */
static Move moveptr;                   /* used by movelist_add() */

#define on_board(o,y,x) (((unsigned)(y + to_rank(o)) < 8) && ((unsigned)(x + to_file(o)) < 8))

static void movelist_add P__((int from, int to, int prom));
static void move_piece P__((int offset, int colour, int y, int x, int multi));
static void promote P__((int from, int to));

static void
movelist_add(from, to, prom)
    int from, to, prom;
{
    if (king_offset != 0xff) {
        if (to == king_offset)
            in_check++;
        return;
    }
    if (moveidx >= NMOVELIST) {
        error("movelist overflow!");
        return;
    }
    moveptr->from = from;
    moveptr->to = to;
    moveptr->prom = prom;
    moveptr++;
    moveidx++;
}

static void
move_piece(offset, colour, y, x, multi)
    int offset, colour, y, x, multi;
{
    int to, delta;

    to = offset;
    delta = (x * 8) + y;

    if (!on_board(to, y, x))
        return;
    do {
        to += delta;
        if (!cb_board[to])
            movelist_add(offset, to, 0);
        else if ((cb_board[to] ^ colour) > 8) {
            movelist_add(offset, to, 0);
            return;
        } else
            return;
    } while (multi && on_board(to, y, x));
}

static void
promote(from, to)
    int from, to;
{
    movelist_add(from, to, QUEEN);
    movelist_add(from, to, ROOK);
    movelist_add(from, to, BISHOP);
    movelist_add(from, to, KNIGHT);
}

/*
 * IS_CHECK
 *
 * Test whether a side is in check.
 *
 * "colour" is the side which has just made a move.
 */
int
is_check(colour)
    int colour;
{
    register int i;
    int moveidx_orig;
    u_char enemy_king;

 /* generate the enemy king bits */
    enemy_king = KING;
    if (!colour)
        enemy_king |= 8;

    king_offset = 0xff;
    moveidx_orig = moveidx;
    for (i = 0; i < 64; i++) {
        if (cb_board[i] == enemy_king) {
            king_offset = i;
            break;
        }
    }
    if (king_offset == 0xff)
        return 0;                      /* No enemy king, so it can't be in
                                          check */

    in_check = 0;

    gen_movelist(colour);

    king_offset = 0xff;                /* reset */
    moveidx = moveidx_orig;

    return in_check;
}

/*
 * GEN_MOVELIST
 *
 * Create a list of all possible moves for a particular colour.
 *
 * Arguments:
 *      colour: non-zero for black moves, else white.
 */
int
gen_movelist(colour)
    int colour;
{
    register int offset;

    moveidx = 0;
    moveptr = &movelist[0];

    if (colour)
        colour = 8;                    /* convert to "colour bit" */
    for (offset = 0; offset < 64; offset++) {
        switch ((cb_board[offset] & 0xf) ^ colour) {
        case KING:{
                int to;

                move_piece(offset, colour, -1, -1, 0);
                move_piece(offset, colour, 0, -1, 0);
                move_piece(offset, colour, 1, -1, 0);
                move_piece(offset, colour, -1, 0, 0);
                move_piece(offset, colour, 1, 0, 0);
                move_piece(offset, colour, -1, 1, 0);
                move_piece(offset, colour, 0, 1, 0);
                move_piece(offset, colour, 1, 1, 0);
                if ((!colour && (offset == 32)) || (colour && (offset == 39))) {
                    to = offset + 16;
                    if (cb_board[offset + 24] == (u_char) (ROOK + colour) &&
                      !cb_board[to] && !cb_board[offset + 8])
                        movelist_add(offset, to, 0);
                    to = offset - 16;
                    if (cb_board[offset - 32] == (u_char) (ROOK + colour) &&
                      !cb_board[offset - 24] && !cb_board[to] &&
                      !cb_board[offset - 8])
                        movelist_add(offset, to, 0);
                }
            }
            break;
        case QUEEN:
            move_piece(offset, colour, -1, -1, 1);
            move_piece(offset, colour, -1, 1, 1);
            move_piece(offset, colour, 1, 1, 1);
            move_piece(offset, colour, 1, -1, 1);
            move_piece(offset, colour, 0, -1, 1);
            move_piece(offset, colour, -1, 0, 1);
            move_piece(offset, colour, 0, 1, 1);
            move_piece(offset, colour, 1, 0, 1);
            break;
        case KNIGHT:
            move_piece(offset, colour, -1, -2, 0);
            move_piece(offset, colour, 1, -2, 0);
            move_piece(offset, colour, -1, 2, 0);
            move_piece(offset, colour, 1, 2, 0);
            move_piece(offset, colour, -2, -1, 0);
            move_piece(offset, colour, 2, -1, 0);
            move_piece(offset, colour, -2, 1, 0);
            move_piece(offset, colour, 2, 1, 0);
            break;
        case BISHOP:
            move_piece(offset, colour, -1, -1, 1);
            move_piece(offset, colour, -1, 1, 1);
            move_piece(offset, colour, 1, 1, 1);
            move_piece(offset, colour, 1, -1, 1);
            break;
        case ROOK:
            move_piece(offset, colour, 0, -1, 1);
            move_piece(offset, colour, -1, 0, 1);
            move_piece(offset, colour, 0, 1, 1);
            move_piece(offset, colour, 1, 0, 1);
            break;
        case PAWN:{
                int h, to, dir, pl;

                if (colour) {
                    dir = -1;          /* black */
                    pl = 6;
                } else {
                    dir = 1;           /* white */
                    pl = 1;
                }
                to = offset + dir;
                if (!cb_board[to]) {
                    to += dir;
                    if (to_rank(offset) == pl && !cb_board[to])
                        movelist_add(offset, to, 0);
                    to -= dir;
                    if (to_rank(to) == 7 - pl + dir)
                        promote(offset, to);
                    else
                        movelist_add(offset, to, 0);
                }
                to = offset - 8 + dir;
                if (offset & 0x38 && (cb_board[to] ^ colour) > 8)
                    if (to_rank(to) == 7 - pl + dir)
                        promote(offset, to);
                    else
                        movelist_add(offset, to, 0);
                to = offset + 8 + dir;
                if ((offset & 0x38) != 0x38 && (cb_board[to] ^ colour) > 8)
                    if (to_rank(to) == 7 - pl + dir)
                        promote(offset, to);
                    else
                        movelist_add(offset, to, 0);
                if (to_rank(offset) == pl + 3 * dir) {
                    h = to_file(offset) - cb_enpassant;
                    to = offset - 8 + dir;
                    if (!h)
                        movelist_add(offset, to, 0);
                    to = offset + 8 + dir;
                    if (h == -2)
                        movelist_add(offset, to, 0);
                }
            }
            break;
        }
    }

    return moveidx;
}
