#include "global.h"

static u_char get_move P__((u_char ** mpptr, int *lenptr));

/*
 * MATCH_MOVES
 *
 * Test two lists of moves to see if they match, regardless of variations
 * and annotations.
 */
int
match_moves(mptr1, len1, mptr2, len2)
    u_char *mptr1, *mptr2;
    int len1, len2;
{
    do
        if (get_move(&mptr1, &len1) != get_move(&mptr2, &len2))
            return 0;
    while (len1 > 0 && len2 > 0);
    return 1;
}

/*
 * GET_MOVE
 *
 * Get the next main-line move from a list, and update the pointer.
 */
static u_char
get_move(mpptr, lenptr)
    u_char **mpptr;
    int *lenptr;
{
    int level, mlen;
    u_char *mptr, move;

    level = 0;
    mptr = *mpptr;
    mlen = *lenptr;
    move = *mptr++;
    mlen--;
    if (move == 0xff) {
        level++;
        while (level && mlen) {
            move = *mptr++;
            mlen--;
            if (move == 0xff)
                level++;
            else if (move == 0x80)
                level--;
        }
        move = *mptr++;
        mlen--;
    }
    *mpptr = mptr;
    *lenptr = mlen;
    return move & 0x7f;
}
