#include "global.h"

/*
 * KR_WRITE
 *
 * Write a key record to a file.
 *
 * Returns -1 upon error.
 */
int
kr_write(file, recnum)
    File file;
    u_long recnum;
{
    KR kr_addr;
    u_char xkr[80];
    u_short type;
    int i;

    kr_addr = (KR) mps_getblk(recnum);
    if (!kr_addr)
        return -1;

    type = kr_addr->type;

    switch (type) {
    case KR_MASTER_TYPE:
        kr_putentry(kr_addr->data.m.nkeys, &xkr[8]);
        kr_putentry(kr_addr->data.m.nrecs, &xkr[11]);
        kr_putentry(kr_addr->data.m.lastgame, &xkr[14]);
        bcopy(kr_addr->data.m.title, &xkr[17], MASTER_TITLE_LEN);
        break;
    case KR_KEY_TYPE:
        kr_putentry(kr_addr->data.k.index, &xkr[8]);
        bcopy(kr_addr->data.k.name, &xkr[11], KEY_NAME_LEN);
        break;
    case KR_INDEX_TYPE:
        for (i = 0; i < KR_ENTRY_MAX; i++)
            kr_putentry(kr_addr->data.i.entry[i], &xkr[(i * 3) + 8]);
        break;
    default:
        bzero(xkr, 80);
        break;
    }

    xkr[0] = (u_char) (type >> 8);
    xkr[1] = (u_char) type;
    kr_putentry(kr_addr->next, &xkr[2]);
    kr_putentry(kr_addr->prev, &xkr[5]);

    if (file_write(file, (char *) xkr, 80) != 80)
        return -1;
    return 0;
}
