#include "global.h"

/*
 * KR_READ_ALL
 *
 * Read a whole key file.
 */
int
kr_read_all(file)
    File file;
{
    register u_long i;
    u_long nrecs;
    KR kr_addr;

    file_seek(file, 0L);

    if (mps_addblk(0L) < 0)
        return -1;
    if (kr_read(file, 0L) < 0)
        return -1;
    kr_addr = (KR) mps_getblk(0L);
    if (!kr_addr)
        return -1;
    if (kr_addr->type != KR_MASTER_TYPE) {
        error("master key record not first record in file!");
        return -1;
    }
    nrecs = kr_addr->data.m.nrecs;
    for (i = 1; i < nrecs; i++) {
        if (mps_addblk(i) < 0)
            return -1;
        if (kr_read(file, i) < 0)
            return -1;
    }
    return 0;
}
