#include "global.h"

/*
 * KR_READ
 *
 * Read a key record from a file.
 *
 * Returns -1 upon error.
 */
int
kr_read(file, recnum)
    File file;
    u_long recnum;
{
    KR kr_addr;
    u_char xkr[80];
    u_short type;
    int i;

    kr_addr = (KR) mps_getblk(recnum);
    if (!kr_addr)
        return -1;

    if (file_read(file, (char *) xkr, sizeof(xkr)) != sizeof(xkr))
        return -1;

    type = (u_short) (xkr[0] << 8);
    type |= (u_short) xkr[1];

    switch (type) {
    case KR_EMPTY_TYPE:
        bzero(kr_addr, sizeof(struct kr));
        break;
    case KR_MASTER_TYPE:
        kr_addr->data.m.nkeys = kr_getentry(&xkr[8]);
        kr_addr->data.m.nrecs = kr_getentry(&xkr[11]);
        kr_addr->data.m.lastgame = kr_getentry(&xkr[14]);
        break;
    case KR_KEY_TYPE1:
	case KR_KEY_TYPE2:
        kr_addr->data.k.index = kr_getentry(&xkr[8]);
        bcopy(&xkr[11], kr_addr->data.k.name, KEY_NAME_LEN);
        break;
    case KR_INDEX_TYPE:
        for (i = 0; i < KR_ENTRY_MAX; i++)
            kr_addr->data.i.entry[i] = kr_getentry(&xkr[(i * 3) + 8]);
        break;
    default:
        break;
    }

    kr_addr->type = type;
    kr_addr->next = kr_getentry(&xkr[2]);
    kr_addr->prev = kr_getentry(&xkr[5]);

    return 0;
}
