#include "global.h"

/*
 * IS_MATE
 *
 * Returns 1 if the current position is mate.
 *
 * "colour" is the side that has just made a move.
 */
int
is_mate(colour)
    int colour;
{
    u_char orig_board[64];
    int orig_ep, i;
    Move moveptr;
    struct move saved_lastmove;
    int saved_lastmove_num;
    u_short saved_lastmove_flags;

    copy_board(cb_board, orig_board);
    orig_ep = cb_enpassant;
    saved_lastmove = lastmove;
    saved_lastmove_num = lastmove_num;
    saved_lastmove_flags = lastmove_flags;

 /* generate a list of posible moves available to the opponent */
    gen_movelist(colour ? 0 : 1);

 /* do each move and check if check; if one is not check then it's not
    checkmate */
    for (i = 0; i < moveidx; i++) {
        copy_board(orig_board, cb_board);
        cb_enpassant = orig_ep;
        moveptr = &movelist[i];
        do_move(moveptr->from, moveptr->to, moveptr->prom);
        if (!is_check(colour))
            break;
    }
    copy_board(orig_board, cb_board);
    cb_enpassant = orig_ep;
    lastmove = saved_lastmove;
    lastmove_num = saved_lastmove_num;
    lastmove_flags = saved_lastmove_flags;

    if (i == moveidx)
        return 1;                      /* mate */
    return 0;
}
