#include "global.h"
#include <sys/stat.h>

/*
 * ISFILE
 *
 * Return 1 if the named file is a plain file, 0 if the named file is some
 * other form of object, and -1 if an error occurs determining its type.
 */
int
isfile(file)
    char *file;
{
    struct stat statbuf;

    if (stat(file, &statbuf) < 0)
        return -1;
    if (statbuf.st_mode & S_IFREG)
        return 1;
    return 0;
}
