#include "global.h"
#include <sys/stat.h>

/*
 * ISDIR
 *
 * Return 1 if the named file is a directory, 0 if the named file is some
 * other form of object, and -1 if an error occurs determining its type.
 */
int
isdir(dir)
    char *dir;
{
    struct stat statbuf;

    if (stat(dir, &statbuf) < 0)
        return -1;
    if (statbuf.st_mode & S_IFDIR)
        return 1;
    return 0;
}
