#include "global.h"

/*
 * FORMAT_MOVETYPE
 *
 * Return a string which describes the type of move parsed, based on the
 * token returned from (f)lex.
 */
char *
format_movetype(token)
    MoveToken token;
{
    switch (token) {
    case MT_PAWN_MOVE:
        return "pawn move";
    case MT_PAWN_MOVE_P:
        return "pawn promotion";
    case MT_PAWN_CAPTURE:
	case MT_PAWN_CAPTURE_SHORT:
        return "pawn capture";
    case MT_PAWN_CAPTURE_P:
	case MT_PAWN_CAPTURE_SHORT_P:
        return "pawn capture and promotion";
    case MT_PIECE_MOVE:
    case MT_PIECE_MOVE_F:
    case MT_PIECE_MOVE_R:
    case MT_PIECE_MOVE_FR:
        return "piece move";
    case MT_PIECE_CAPTURE:
    case MT_PIECE_CAPTURE_F:
    case MT_PIECE_CAPTURE_R:
    case MT_PIECE_CAPTURE_FR:
        return "piece capture";
    case MT_KSIDE_CASTLE:
        return "kingside castle";
    case MT_QSIDE_CASTLE:
        return "queenside castle";
    default:
        return "move";
    }
}
