#include "global.h"

/*
 * FORMAT_INFO
 *
 * Format the information about a game into a string.
 */
char *
format_info(game, brief)
    Game game;
    int brief;
{
    register int i;
    char pinfo[26], sinfo[24], year[5], eco[8];
    static char line[80];

    for (i = 0; i < 25; i++) {
        pinfo[i] = game->pinfo[i];
        if (pinfo[i] == '\0')
            break;
    }
    for (; i < 25; i++)
        pinfo[i] = ' ';
    pinfo[25] = '\0';

    for (i = 0; i < 23; i++) {
        sinfo[i] = game->sinfo[i];
        if (sinfo[i] == '\0')
            break;
    }
    for (; i < 23; i++)
        sinfo[i] = ' ';
    sinfo[23] = '\0';

    if (brief) {
        sprintf(line, "%-5lu %s %s", game->num, pinfo, sinfo);
        return line;
    }
    if (game->year)
        sprintf(year, "%d", game->year);
    else
        strcpy(year, "    ");

    if (game->eco_letter)
        sprintf(eco, "%c%02d", game->eco_letter, game->eco_main);
    else
        strcpy(eco, "   ");

    sprintf(line, "%-5lu %s %s %s %s %4s %3d %c", game->num, pinfo, sinfo,
      eco, year, cvt_result(get_result(game->header)), game->nmoves,
      is_partial(game->header) ? 'p' : ' ');

    return line;
}
