#include "global.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/*
 * FILE_RENAME
 *
 * Rename a file, maintaining the directory elements of the old name and
 * the extension.
 */
int
file_rename(file, newname)
    File file;
    char *newname;
{
    char *cptr, *newpath, *oldname;
    int len, ret;
    long offset;

 /* check that the new names doesn't have any path-seperators or dots */
    if (index(newname, PATHSEP)) {
        error("file_rename(): new name contains path seperators!");
        return -1;
    }
    if (index(newname, '.')) {
        error("file_rename(): new name contains dots!");
        return -1;
    }
    oldname = NULL;
    newpath = NULL;
    ret = 0;

    oldname = xstrdup(file->name);
    if (!oldname)
        return -1;

    cptr = rindex(oldname, PATHSEP);
    if (cptr)
        len = (cptr + 1) - oldname;
    else
        len = 0;
    newpath = mem_alloc(len + 14);
    if (!newpath)
        goto quit;
    strncpy(newpath, oldname, len);
    strcat(newpath, newname);
    cptr = find_ext(oldname);
    if (cptr) {
        strcat(newpath, ".");
        strcat(newpath, cptr);
    }
    offset = file_tell(file);
    close(file->fd);
    free(file->name);
    file->name = newpath;
    newpath = NULL;

    if (rename(oldname, file->name) == 0) {
        file->fd = open(file->name, file->mode, OPENMODE);
        if (file->fd < 0) {
            error("error re-opening file \"%s\"", file->name);
            file_close(file);
            ret = -1;
        } else {
            file_seek(file, offset);
        }
    } else {
        error("error renaming file \"%s\" to \"%s\"",
          oldname, file->name);
        ret = -1;
    }
quit:
    if (oldname)
        free(oldname);
    if (newpath)
        free(newpath);
    return ret;
}
