#include "global.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/*
 * FILE_OPEN
 *
 * Open a file
 */
File
file_open(name, mode)
    char *name, *mode;
{
    File ret;
    int fd, openmode;

    openmode = 0;

    if (*mode == 'r') {
        if (*(mode + 1) == '+') {
            openmode = O_RDWR;
            mode += 2;
        } else {
            openmode = O_RDONLY;
            mode++;
        }
    } else if (*mode == 'w') {
        if (*(mode + 1) == '+') {
            openmode = O_CREAT | O_TRUNC | O_RDWR;
            mode += 2;
        } else {
            openmode = O_CREAT | O_TRUNC | O_WRONLY;
            mode++;
        }
    } else if (*mode == 'a') {
        if (*(mode + 1) == '+') {
            openmode = O_APPEND | O_RDWR;
            mode += 2;
        } else {
            openmode = O_APPEND;
            mode++;
        }
    } else
        return NULL;

#if defined(MSDOS) || defined(WIN32)
    if (*mode == 't')
        openmode |= O_TEXT;
    else if (*mode == 'b')
        openmode |= O_BINARY;
#endif /* MSDOS or WIN32 */

    fd = open(name, openmode, OPENMODE);
    if (fd < 0) {
        error("error opening file \"%s\"", name);
        return NULL;
    }
    ret = (File) mem_alloc(sizeof(struct file));
    if (!ret)
        return NULL;
    ret->name = xstrdup(name);
    if (!ret->name)
        goto fail;
    ret->mode = openmode & ~(O_APPEND | O_TRUNC | O_CREAT);
    ret->fd = fd;

    return ret;

fail:
    close(ret->fd);
    if (ret->name)
        free(ret->name);
    free(ret);
    return NULL;
}
