#include "global.h"

/*
 * FILE_DELETE
 *
 * Close and delete an open file.
 */
int
file_delete(file)
    File file;
{
    int ret = 0;

    if (!file) {
        ret = -1;
    } else {
        if (close(file->fd) != 0) {
            error("error closing file \"%s\"", file->name);
            ret = -1;
        }
        if (unlink(file->name) < 0) {
            error("error deleting file \"%s\"", file->name);
            ret = -1;
        }
        free(file->name);
        free(file);
    }

    return ret;
}
