#include "global.h"

#define COPY_BUF_SZ     8192

/*
 * FILE_COPY
 *
 * Copy the data from one file into the other
 */
int
file_copy(from, to)
    File from, to;
{
    char *buf;
    int nread;

    buf = mem_alloc(COPY_BUF_SZ);
    if (!buf)
        return -1;

    file_seek(from, 0L);
    file_seek(to, 0L);

    do {
    /* use fread() to avoid error messages */
        nread = read(from->fd, buf, COPY_BUF_SZ);
        if (file_write(to, buf, nread) != nread)
            return -1;
    } while (nread == COPY_BUF_SZ);

    free(buf);
}
