#include "global.h"

/*
 * FILE_CLOSE
 *
 * Close an open file.
 */
int
file_close(file)
    File file;
{
    int ret = 0;

    if (!file) {
        ret = -1;
    } else {
        if (file->fd >= 0 && close(file->fd) != 0) {
            error("error closing file \"%s\"", file->name);
            ret = -1;
        }
        free(file->name);
        free(file);
    }

    return ret;
}
