#include "global.h"

FILE *fp_error = stdout;

/*
 * ERROR
 *
 * Report error to user.
 *
 * Returns the number of characters printed.
 */
#ifdef ANSI_C
int
error(char *fmt,...)
{
    va_list ap;
    int ret;

    if (no_error)
        return 0;

    va_start(ap, fmt);
    ret = vfprintf(fp_error, fmt, ap);
    va_end(ap);
    fputc('\n', fp_error);
    fflush(fp_error);
    return ret;
}
#else                                  /* ANSI_C */
int
error(va_alist)
va_dcl
{
    va_list ap;
    char *fmt;
    int ret;

    if (no_error)
        return 0;

    va_start(ap);
    fmt = va_arg(ap, char *);
    ret = vfprintf(fp_error, fmt, ap);
    va_end(ap);
    fputc('\n', fp_error);
    fflush(fp_error);
    return ret;
}
#endif                                 /* ANSI_C */
