#include "global.h"

/*
 * DUMP_BOARD
 *
 * Dump the contents of the current board position "cb_board".
 */

void
dump_board(board, outfile)
    u_char *board;
    FILE *outfile;
{
    int file, rank, piece, idx;

    fputs("   a b c d e f g h\n +-----------------+\n", outfile);
    for (rank = 7; rank >= 0; rank--) {
        fprintf(outfile, "%d| ", rank + 1);
        for (file = 0; file < 8; file++) {
            piece = board[to_offset(file, rank)];
            if (piece == 0xff) {
                fputc('*', outfile);
            } else {
                idx = piece & 0x7;
                if (piece & 0x8 && idx)
                    fputc(piece_list[idx] + 'a' - 'A', outfile);
                else
                    fputc(piece_list[idx], outfile);
            }
            fputc(' ', outfile);
        }
        fprintf(outfile, "|%d\n", rank + 1);
    }
    fputs(" +-----------------+\n   a b c d e f g h\n", outfile);
}

char
dump_piece(piece)
    u_char piece;
{
    if (piece > 7)
        return '?';
    return piece_list[piece];
}
