#include "global.h"

/*
 * DO_MOVE
 *
 * Move pieces on board according to given move.
 */
void
do_move(from, to, prom)
    int from, to, prom;
{
    int dir;
    int colour = cb_board[from] & 8;
    int ep = cb_enpassant;

    lastmove_flags = 0;
    cb_enpassant = 0;
    captured_piece = cb_board[to] & 7;
    if (!colour)
        dir = 1;
    else
        dir = -1;
    if (cb_board[to] & 7)
        lastmove_flags |= CAPTURE;
    if ((cb_board[from] & 7) == PAWN && to_file(to) != to_file(from)
      && !cb_board[to]) {
        cb_board[to - dir] = 0;        /* en passant capture */
        lastmove_flags |= ENPASSANT | CAPTURE;
    }
    cb_board[to] = cb_board[from];
    cb_board[from] = 0;
    if ((cb_board[to] & 7) == PAWN &&
      (to_rank(to) == 7 || to_rank(to) == 0)) {
        cb_board[to] = prom + colour;  /* pawn promotion */
        lastmove_flags |= PROMOTION;
    }
    if ((cb_board[to] & 7) == PAWN && abs(to - from) == 2)
        cb_enpassant = to_file(to) + 1;/* long pawn move */
    if ((cb_board[to] & 7) == KING && abs(to - from) == 16) {
        cb_enpassant = ep;             /* bug compatibility */
        if (to > from) {               /* castle kingside */
            cb_board[to - 8] = cb_board[to + 8];
            cb_board[to + 8] = 0;
            lastmove_flags |= SHORT_CASTLE;
        }
        if (to < from) {               /* castle queenside */
            cb_board[to + 8] = cb_board[to - 16];
            cb_board[to - 16] = 0;
            lastmove_flags |= LONG_CASTLE;
        }
    }
}
